/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductResultItem.Builder, DataProductResultItem> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DataProductResultItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(DataProductResultItem::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DataProductResultItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(DataProductResultItem::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstRevisionCreatedAt").getter(getter(DataProductResultItem::firstRevisionCreatedAt))
            .setter(setter(Builder::firstRevisionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build())
            .build();

    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstRevisionCreatedBy").getter(getter(DataProductResultItem::firstRevisionCreatedBy))
            .setter(setter(Builder::firstRevisionCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build())
            .build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(DataProductResultItem::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DataProductResultItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataProductResultItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(DataProductResultItem::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, FIRST_REVISION_CREATED_AT_FIELD,
            FIRST_REVISION_CREATED_BY_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final Instant firstRevisionCreatedAt;

    private final String firstRevisionCreatedBy;

    private final List<String> glossaryTerms;

    private final String id;

    private final String name;

    private final String owningProjectId;

    private DataProductResultItem(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
    }

    /**
     * <p>
     * The timestamp at which the data product was created.
     * </p>
     * 
     * @return The timestamp at which the data product was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data product.
     * </p>
     * 
     * @return The user who created the data product.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the data product.
     * </p>
     * 
     * @return The description of the data product.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where the data product lives.
     * </p>
     * 
     * @return The ID of the domain where the data product lives.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The timestamp at which first revision of the data product was created.
     * </p>
     * 
     * @return The timestamp at which first revision of the data product was created.
     */
    public final Instant firstRevisionCreatedAt() {
        return firstRevisionCreatedAt;
    }

    /**
     * <p>
     * The user who created the first revision of the data product.
     * </p>
     * 
     * @return The user who created the first revision of the data product.
     */
    public final String firstRevisionCreatedBy() {
        return firstRevisionCreatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the data product.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of the data product.
     * </p>
     * 
     * @return The ID of the data product.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the data product.
     * </p>
     * 
     * @return The name of the data product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the owning project of the data product.
     * </p>
     * 
     * @return The ID of the owning project of the data product.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductResultItem)) {
            return false;
        }
        DataProductResultItem other = (DataProductResultItem) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(firstRevisionCreatedAt(), other.firstRevisionCreatedAt())
                && Objects.equals(firstRevisionCreatedBy(), other.firstRevisionCreatedBy())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectId(), other.owningProjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductResultItem").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("FirstRevisionCreatedAt", firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", firstRevisionCreatedBy())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", owningProjectId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "firstRevisionCreatedAt":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedAt()));
        case "firstRevisionCreatedBy":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedBy()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("firstRevisionCreatedAt", FIRST_REVISION_CREATED_AT_FIELD);
        map.put("firstRevisionCreatedBy", FIRST_REVISION_CREATED_BY_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProductResultItem, T> g) {
        return obj -> g.apply((DataProductResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductResultItem> {
        /**
         * <p>
         * The timestamp at which the data product was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data product was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data product.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the data product.
         * </p>
         * 
         * @param description
         *        The description of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where the data product lives.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where the data product lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The timestamp at which first revision of the data product was created.
         * </p>
         * 
         * @param firstRevisionCreatedAt
         *        The timestamp at which first revision of the data product was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt);

        /**
         * <p>
         * The user who created the first revision of the data product.
         * </p>
         * 
         * @param firstRevisionCreatedBy
         *        The user who created the first revision of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedBy(String firstRevisionCreatedBy);

        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of the data product.
         * </p>
         * 
         * @param id
         *        The ID of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the data product.
         * </p>
         * 
         * @param name
         *        The name of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the owning project of the data product.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the owning project of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private Instant firstRevisionCreatedAt;

        private String firstRevisionCreatedBy;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String name;

        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductResultItem model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            name(model.name);
            owningProjectId(model.owningProjectId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        @Override
        public DataProductResultItem build() {
            return new DataProductResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
