/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the error message that is returned if the operation cannot be successfully completed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceErrorMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceErrorMessage.Builder, DataSourceErrorMessage> {
    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDetail").getter(getter(DataSourceErrorMessage::errorDetail)).setter(setter(Builder::errorDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetail").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(DataSourceErrorMessage::errorTypeAsString)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DETAIL_FIELD,
            ERROR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorDetail;

    private final String errorType;

    private DataSourceErrorMessage(BuilderImpl builder) {
        this.errorDetail = builder.errorDetail;
        this.errorType = builder.errorType;
    }

    /**
     * <p>
     * The details of the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * 
     * @return The details of the error message that is returned if the operation cannot be successfully completed.
     */
    public final String errorDetail() {
        return errorDetail;
    }

    /**
     * <p>
     * The type of the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link DataSourceErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of the error message that is returned if the operation cannot be successfully completed.
     * @see DataSourceErrorType
     */
    public final DataSourceErrorType errorType() {
        return DataSourceErrorType.fromValue(errorType);
    }

    /**
     * <p>
     * The type of the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link DataSourceErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of the error message that is returned if the operation cannot be successfully completed.
     * @see DataSourceErrorType
     */
    public final String errorTypeAsString() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        hashCode = 31 * hashCode + Objects.hashCode(errorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceErrorMessage)) {
            return false;
        }
        DataSourceErrorMessage other = (DataSourceErrorMessage) obj;
        return Objects.equals(errorDetail(), other.errorDetail())
                && Objects.equals(errorTypeAsString(), other.errorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceErrorMessage").add("ErrorDetail", errorDetail()).add("ErrorType", errorTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorDetail", ERROR_DETAIL_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceErrorMessage, T> g) {
        return obj -> g.apply((DataSourceErrorMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceErrorMessage> {
        /**
         * <p>
         * The details of the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param errorDetail
         *        The details of the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(String errorDetail);

        /**
         * <p>
         * The type of the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param errorType
         *        The type of the error message that is returned if the operation cannot be successfully completed.
         * @see DataSourceErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceErrorType
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * The type of the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param errorType
         *        The type of the error message that is returned if the operation cannot be successfully completed.
         * @see DataSourceErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceErrorType
         */
        Builder errorType(DataSourceErrorType errorType);
    }

    static final class BuilderImpl implements Builder {
        private String errorDetail;

        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceErrorMessage model) {
            errorDetail(model.errorDetail);
            errorType(model.errorType);
        }

        public final String getErrorDetail() {
            return errorDetail;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(DataSourceErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public DataSourceErrorMessage build() {
            return new DataSourceErrorMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
