/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The grant filter for the domain unit. In the current release of Amazon DataZone, the only supported filter is the
 * <code>allDomainUnitsGrantFilter</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainUnitGrantFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainUnitGrantFilter.Builder, DomainUnitGrantFilter> {
    private static final SdkField<AllDomainUnitsGrantFilter> ALL_DOMAIN_UNITS_GRANT_FILTER_FIELD = SdkField
            .<AllDomainUnitsGrantFilter> builder(MarshallingType.SDK_POJO).memberName("allDomainUnitsGrantFilter")
            .getter(getter(DomainUnitGrantFilter::allDomainUnitsGrantFilter)).setter(setter(Builder::allDomainUnitsGrantFilter))
            .constructor(AllDomainUnitsGrantFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allDomainUnitsGrantFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALL_DOMAIN_UNITS_GRANT_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AllDomainUnitsGrantFilter allDomainUnitsGrantFilter;

    private final Type type;

    private DomainUnitGrantFilter(BuilderImpl builder) {
        this.allDomainUnitsGrantFilter = builder.allDomainUnitsGrantFilter;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies a grant filter containing all domain units.
     * </p>
     * 
     * @return Specifies a grant filter containing all domain units.
     */
    public final AllDomainUnitsGrantFilter allDomainUnitsGrantFilter() {
        return allDomainUnitsGrantFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allDomainUnitsGrantFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitGrantFilter)) {
            return false;
        }
        DomainUnitGrantFilter other = (DomainUnitGrantFilter) obj;
        return Objects.equals(allDomainUnitsGrantFilter(), other.allDomainUnitsGrantFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainUnitGrantFilter").add("AllDomainUnitsGrantFilter", allDomainUnitsGrantFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allDomainUnitsGrantFilter":
            return Optional.ofNullable(clazz.cast(allDomainUnitsGrantFilter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #allDomainUnitsGrantFilter()} initialized to the given value.
     *
     * <p>
     * Specifies a grant filter containing all domain units.
     * </p>
     * 
     * @param allDomainUnitsGrantFilter
     *        Specifies a grant filter containing all domain units.
     */
    public static DomainUnitGrantFilter fromAllDomainUnitsGrantFilter(AllDomainUnitsGrantFilter allDomainUnitsGrantFilter) {
        return builder().allDomainUnitsGrantFilter(allDomainUnitsGrantFilter).build();
    }

    /**
     * Create an instance of this class with {@link #allDomainUnitsGrantFilter()} initialized to the given value.
     *
     * <p>
     * Specifies a grant filter containing all domain units.
     * </p>
     * 
     * @param allDomainUnitsGrantFilter
     *        Specifies a grant filter containing all domain units.
     */
    public static DomainUnitGrantFilter fromAllDomainUnitsGrantFilter(
            Consumer<AllDomainUnitsGrantFilter.Builder> allDomainUnitsGrantFilter) {
        AllDomainUnitsGrantFilter.Builder builder = AllDomainUnitsGrantFilter.builder();
        allDomainUnitsGrantFilter.accept(builder);
        return fromAllDomainUnitsGrantFilter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allDomainUnitsGrantFilter", ALL_DOMAIN_UNITS_GRANT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitGrantFilter, T> g) {
        return obj -> g.apply((DomainUnitGrantFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainUnitGrantFilter> {
        /**
         * <p>
         * Specifies a grant filter containing all domain units.
         * </p>
         * 
         * @param allDomainUnitsGrantFilter
         *        Specifies a grant filter containing all domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allDomainUnitsGrantFilter(AllDomainUnitsGrantFilter allDomainUnitsGrantFilter);

        /**
         * <p>
         * Specifies a grant filter containing all domain units.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllDomainUnitsGrantFilter.Builder}
         * avoiding the need to create one manually via {@link AllDomainUnitsGrantFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllDomainUnitsGrantFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #allDomainUnitsGrantFilter(AllDomainUnitsGrantFilter)}.
         * 
         * @param allDomainUnitsGrantFilter
         *        a consumer that will call methods on {@link AllDomainUnitsGrantFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allDomainUnitsGrantFilter(AllDomainUnitsGrantFilter)
         */
        default Builder allDomainUnitsGrantFilter(Consumer<AllDomainUnitsGrantFilter.Builder> allDomainUnitsGrantFilter) {
            return allDomainUnitsGrantFilter(AllDomainUnitsGrantFilter.builder().applyMutation(allDomainUnitsGrantFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AllDomainUnitsGrantFilter allDomainUnitsGrantFilter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitGrantFilter model) {
            allDomainUnitsGrantFilter(model.allDomainUnitsGrantFilter);
        }

        public final AllDomainUnitsGrantFilter.Builder getAllDomainUnitsGrantFilter() {
            return allDomainUnitsGrantFilter != null ? allDomainUnitsGrantFilter.toBuilder() : null;
        }

        public final void setAllDomainUnitsGrantFilter(AllDomainUnitsGrantFilter.BuilderImpl allDomainUnitsGrantFilter) {
            Object oldValue = this.allDomainUnitsGrantFilter;
            this.allDomainUnitsGrantFilter = allDomainUnitsGrantFilter != null ? allDomainUnitsGrantFilter.build() : null;
            handleUnionValueChange(Type.ALL_DOMAIN_UNITS_GRANT_FILTER, oldValue, this.allDomainUnitsGrantFilter);
        }

        @Override
        public final Builder allDomainUnitsGrantFilter(AllDomainUnitsGrantFilter allDomainUnitsGrantFilter) {
            Object oldValue = this.allDomainUnitsGrantFilter;
            this.allDomainUnitsGrantFilter = allDomainUnitsGrantFilter;
            handleUnionValueChange(Type.ALL_DOMAIN_UNITS_GRANT_FILTER, oldValue, this.allDomainUnitsGrantFilter);
            return this;
        }

        @Override
        public DomainUnitGrantFilter build() {
            return new DomainUnitGrantFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DomainUnitGrantFilter#type()
     */
    public enum Type {
        ALL_DOMAIN_UNITS_GRANT_FILTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
