/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class EnvironmentFailureReasonsCopier {
    static Map<String, List<EnvironmentError>> copy(
            Map<String, ? extends Collection<? extends EnvironmentError>> environmentFailureReasonsParam) {
        Map<String, List<EnvironmentError>> map;
        if (environmentFailureReasonsParam == null || environmentFailureReasonsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<EnvironmentError>> modifiableMap = new LinkedHashMap<>(environmentFailureReasonsParam.size());
            environmentFailureReasonsParam.forEach((key, value) -> {
                List<EnvironmentError> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<EnvironmentError> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<EnvironmentError>> copyFromBuilder(
            Map<String, ? extends Collection<? extends EnvironmentError.Builder>> environmentFailureReasonsParam) {
        Map<String, List<EnvironmentError>> map;
        if (environmentFailureReasonsParam == null || environmentFailureReasonsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<EnvironmentError>> modifiableMap = new LinkedHashMap<>(environmentFailureReasonsParam.size());
            environmentFailureReasonsParam.forEach((key, value) -> {
                List<EnvironmentError> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<EnvironmentError> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        EnvironmentError member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<EnvironmentError.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends EnvironmentError>> environmentFailureReasonsParam) {
        Map<String, List<EnvironmentError.Builder>> map;
        if (environmentFailureReasonsParam == null || environmentFailureReasonsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<EnvironmentError.Builder>> modifiableMap = new LinkedHashMap<>(environmentFailureReasonsParam.size());
            environmentFailureReasonsParam.forEach((key, value) -> {
                List<EnvironmentError.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<EnvironmentError.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        EnvironmentError.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
