/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSummary implements SdkPojo, Serializable, ToCopyableBuilder<EventSummary.Builder, EventSummary> {
    private static final SdkField<OpenLineageRunEventSummary> OPEN_LINEAGE_RUN_EVENT_SUMMARY_FIELD = SdkField
            .<OpenLineageRunEventSummary> builder(MarshallingType.SDK_POJO)
            .memberName("openLineageRunEventSummary")
            .getter(getter(EventSummary::openLineageRunEventSummary))
            .setter(setter(Builder::openLineageRunEventSummary))
            .constructor(OpenLineageRunEventSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openLineageRunEventSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPEN_LINEAGE_RUN_EVENT_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpenLineageRunEventSummary openLineageRunEventSummary;

    private final Type type;

    private EventSummary(BuilderImpl builder) {
        this.openLineageRunEventSummary = builder.openLineageRunEventSummary;
        this.type = builder.type;
    }

    /**
     * <p>
     * The open lineage run event summary.
     * </p>
     * 
     * @return The open lineage run event summary.
     */
    public final OpenLineageRunEventSummary openLineageRunEventSummary() {
        return openLineageRunEventSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openLineageRunEventSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSummary)) {
            return false;
        }
        EventSummary other = (EventSummary) obj;
        return Objects.equals(openLineageRunEventSummary(), other.openLineageRunEventSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSummary").add("OpenLineageRunEventSummary", openLineageRunEventSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openLineageRunEventSummary":
            return Optional.ofNullable(clazz.cast(openLineageRunEventSummary()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #openLineageRunEventSummary()} initialized to the given value.
     *
     * <p>
     * The open lineage run event summary.
     * </p>
     * 
     * @param openLineageRunEventSummary
     *        The open lineage run event summary.
     */
    public static EventSummary fromOpenLineageRunEventSummary(OpenLineageRunEventSummary openLineageRunEventSummary) {
        return builder().openLineageRunEventSummary(openLineageRunEventSummary).build();
    }

    /**
     * Create an instance of this class with {@link #openLineageRunEventSummary()} initialized to the given value.
     *
     * <p>
     * The open lineage run event summary.
     * </p>
     * 
     * @param openLineageRunEventSummary
     *        The open lineage run event summary.
     */
    public static EventSummary fromOpenLineageRunEventSummary(
            Consumer<OpenLineageRunEventSummary.Builder> openLineageRunEventSummary) {
        OpenLineageRunEventSummary.Builder builder = OpenLineageRunEventSummary.builder();
        openLineageRunEventSummary.accept(builder);
        return fromOpenLineageRunEventSummary(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("openLineageRunEventSummary", OPEN_LINEAGE_RUN_EVENT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventSummary, T> g) {
        return obj -> g.apply((EventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSummary> {
        /**
         * <p>
         * The open lineage run event summary.
         * </p>
         * 
         * @param openLineageRunEventSummary
         *        The open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openLineageRunEventSummary(OpenLineageRunEventSummary openLineageRunEventSummary);

        /**
         * <p>
         * The open lineage run event summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenLineageRunEventSummary.Builder}
         * avoiding the need to create one manually via {@link OpenLineageRunEventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenLineageRunEventSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #openLineageRunEventSummary(OpenLineageRunEventSummary)}.
         * 
         * @param openLineageRunEventSummary
         *        a consumer that will call methods on {@link OpenLineageRunEventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openLineageRunEventSummary(OpenLineageRunEventSummary)
         */
        default Builder openLineageRunEventSummary(Consumer<OpenLineageRunEventSummary.Builder> openLineageRunEventSummary) {
            return openLineageRunEventSummary(OpenLineageRunEventSummary.builder().applyMutation(openLineageRunEventSummary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenLineageRunEventSummary openLineageRunEventSummary;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventSummary model) {
            openLineageRunEventSummary(model.openLineageRunEventSummary);
        }

        public final OpenLineageRunEventSummary.Builder getOpenLineageRunEventSummary() {
            return openLineageRunEventSummary != null ? openLineageRunEventSummary.toBuilder() : null;
        }

        public final void setOpenLineageRunEventSummary(OpenLineageRunEventSummary.BuilderImpl openLineageRunEventSummary) {
            Object oldValue = this.openLineageRunEventSummary;
            this.openLineageRunEventSummary = openLineageRunEventSummary != null ? openLineageRunEventSummary.build() : null;
            handleUnionValueChange(Type.OPEN_LINEAGE_RUN_EVENT_SUMMARY, oldValue, this.openLineageRunEventSummary);
        }

        @Override
        public final Builder openLineageRunEventSummary(OpenLineageRunEventSummary openLineageRunEventSummary) {
            Object oldValue = this.openLineageRunEventSummary;
            this.openLineageRunEventSummary = openLineageRunEventSummary;
            handleUnionValueChange(Type.OPEN_LINEAGE_RUN_EVENT_SUMMARY, oldValue, this.openLineageRunEventSummary);
            return this;
        }

        @Override
        public EventSummary build() {
            return new EventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EventSummary#type()
     */
    public enum Type {
        OPEN_LINEAGE_RUN_EVENT_SUMMARY,

        UNKNOWN_TO_SDK_VERSION
    }
}
