/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentCredentialsResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetEnvironmentCredentialsResponse.Builder, GetEnvironmentCredentialsResponse> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessKeyId").getter(getter(GetEnvironmentCredentialsResponse::accessKeyId))
            .setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiration")
            .getter(getter(GetEnvironmentCredentialsResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretAccessKey").getter(getter(GetEnvironmentCredentialsResponse::secretAccessKey))
            .setter(setter(Builder::secretAccessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionToken").getter(getter(GetEnvironmentCredentialsResponse::sessionToken))
            .setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD,
            EXPIRATION_FIELD, SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessKeyId;

    private final Instant expiration;

    private final String secretAccessKey;

    private final String sessionToken;

    private GetEnvironmentCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeyId = builder.accessKeyId;
        this.expiration = builder.expiration;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
    }

    /**
     * <p>
     * The access key ID of the environment.
     * </p>
     * 
     * @return The access key ID of the environment.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The expiration timestamp of the environment credentials.
     * </p>
     * 
     * @return The expiration timestamp of the environment credentials.
     */
    public final Instant expiration() {
        return expiration;
    }

    /**
     * <p>
     * The secret access key of the environment credentials.
     * </p>
     * 
     * @return The secret access key of the environment credentials.
     */
    public final String secretAccessKey() {
        return secretAccessKey;
    }

    /**
     * <p>
     * The session token of the environment credentials.
     * </p>
     * 
     * @return The session token of the environment credentials.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentCredentialsResponse)) {
            return false;
        }
        GetEnvironmentCredentialsResponse other = (GetEnvironmentCredentialsResponse) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(expiration(), other.expiration())
                && Objects.equals(secretAccessKey(), other.secretAccessKey())
                && Objects.equals(sessionToken(), other.sessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentCredentialsResponse").add("AccessKeyId", accessKeyId())
                .add("Expiration", expiration()).add("SecretAccessKey", secretAccessKey()).add("SessionToken", sessionToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "secretAccessKey":
            return Optional.ofNullable(clazz.cast(secretAccessKey()));
        case "sessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("expiration", EXPIRATION_FIELD);
        map.put("secretAccessKey", SECRET_ACCESS_KEY_FIELD);
        map.put("sessionToken", SESSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentCredentialsResponse, T> g) {
        return obj -> g.apply((GetEnvironmentCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEnvironmentCredentialsResponse> {
        /**
         * <p>
         * The access key ID of the environment.
         * </p>
         * 
         * @param accessKeyId
         *        The access key ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The expiration timestamp of the environment credentials.
         * </p>
         * 
         * @param expiration
         *        The expiration timestamp of the environment credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);

        /**
         * <p>
         * The secret access key of the environment credentials.
         * </p>
         * 
         * @param secretAccessKey
         *        The secret access key of the environment credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessKey(String secretAccessKey);

        /**
         * <p>
         * The session token of the environment credentials.
         * </p>
         * 
         * @param sessionToken
         *        The session token of the environment credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String accessKeyId;

        private Instant expiration;

        private String secretAccessKey;

        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentCredentialsResponse model) {
            super(model);
            accessKeyId(model.accessKeyId);
            expiration(model.expiration);
            secretAccessKey(model.secretAccessKey);
            sessionToken(model.sessionToken);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final String getSecretAccessKey() {
            return secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public GetEnvironmentCredentialsResponse build() {
            return new GetEnvironmentCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
