/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserProfileResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetUserProfileResponse.Builder, GetUserProfileResponse> {
    private static final SdkField<UserProfileDetails> DETAILS_FIELD = SdkField
            .<UserProfileDetails> builder(MarshallingType.SDK_POJO).memberName("details")
            .getter(getter(GetUserProfileResponse::details)).setter(setter(Builder::details))
            .constructor(UserProfileDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetUserProfileResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetUserProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetUserProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetUserProfileResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD,
            DOMAIN_ID_FIELD, ID_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UserProfileDetails details;

    private final String domainId;

    private final String id;

    private final String status;

    private final String type;

    private GetUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Details property for this object.
     * 
     * @return The value of the Details property for this object.
     */
    public final UserProfileDetails details() {
        return details;
    }

    /**
     * <p>
     * the identifier of the Amazon DataZone domain of which you want to get the user profile.
     * </p>
     * 
     * @return the identifier of the Amazon DataZone domain of which you want to get the user profile.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the user profile.
     * </p>
     * 
     * @return The identifier of the user profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the user profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user profile.
     * @see UserProfileStatus
     */
    public final UserProfileStatus status() {
        return UserProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the user profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user profile.
     * @see UserProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the user profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user profile.
     * @see UserProfileType
     */
    public final UserProfileType type() {
        return UserProfileType.fromValue(type);
    }

    /**
     * <p>
     * The type of the user profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user profile.
     * @see UserProfileType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserProfileResponse)) {
            return false;
        }
        GetUserProfileResponse other = (GetUserProfileResponse) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserProfileResponse").add("Details", details()).add("DomainId", domainId()).add("Id", id())
                .add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("details", DETAILS_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserProfileResponse, T> g) {
        return obj -> g.apply((GetUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserProfileResponse> {
        /**
         * Sets the value of the Details property for this object.
         *
         * @param details
         *        The new value for the Details property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(UserProfileDetails details);

        /**
         * Sets the value of the Details property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserProfileDetails.Builder} avoiding the
         * need to create one manually via {@link UserProfileDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserProfileDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(UserProfileDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link UserProfileDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(UserProfileDetails)
         */
        default Builder details(Consumer<UserProfileDetails.Builder> details) {
            return details(UserProfileDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * the identifier of the Amazon DataZone domain of which you want to get the user profile.
         * </p>
         * 
         * @param domainId
         *        the identifier of the Amazon DataZone domain of which you want to get the user profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the user profile.
         * </p>
         * 
         * @param id
         *        The identifier of the user profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the user profile.
         * </p>
         * 
         * @param status
         *        The status of the user profile.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the user profile.
         * </p>
         * 
         * @param status
         *        The status of the user profile.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(UserProfileStatus status);

        /**
         * <p>
         * The type of the user profile.
         * </p>
         * 
         * @param type
         *        The type of the user profile.
         * @see UserProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the user profile.
         * </p>
         * 
         * @param type
         *        The type of the user profile.
         * @see UserProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileType
         */
        Builder type(UserProfileType type);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private UserProfileDetails details;

        private String domainId;

        private String id;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserProfileResponse model) {
            super(model);
            details(model.details);
            domainId(model.domainId);
            id(model.id);
            status(model.status);
            type(model.type);
        }

        public final UserProfileDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(UserProfileDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(UserProfileDetails details) {
            this.details = details;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetUserProfileResponse build() {
            return new GetUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
