/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LineageEventSummariesCopier {
    static List<LineageEventSummary> copy(Collection<? extends LineageEventSummary> lineageEventSummariesParam) {
        List<LineageEventSummary> list;
        if (lineageEventSummariesParam == null || lineageEventSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineageEventSummary> modifiableList = new ArrayList<>(lineageEventSummariesParam.size());
            lineageEventSummariesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LineageEventSummary> copyFromBuilder(Collection<? extends LineageEventSummary.Builder> lineageEventSummariesParam) {
        List<LineageEventSummary> list;
        if (lineageEventSummariesParam == null || lineageEventSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineageEventSummary> modifiableList = new ArrayList<>(lineageEventSummariesParam.size());
            lineageEventSummariesParam.forEach(entry -> {
                LineageEventSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LineageEventSummary.Builder> copyToBuilder(Collection<? extends LineageEventSummary> lineageEventSummariesParam) {
        List<LineageEventSummary.Builder> list;
        if (lineageEventSummariesParam == null || lineageEventSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineageEventSummary.Builder> modifiableList = new ArrayList<>(lineageEventSummariesParam.size());
            lineageEventSummariesParam.forEach(entry -> {
                LineageEventSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
