/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference details for the data lineage node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageNodeReference implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageNodeReference.Builder, LineageNodeReference> {
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp").getter(getter(LineageNodeReference::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(LineageNodeReference::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TIMESTAMP_FIELD,
            ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant eventTimestamp;

    private final String id;

    private LineageNodeReference(BuilderImpl builder) {
        this.eventTimestamp = builder.eventTimestamp;
        this.id = builder.id;
    }

    /**
     * <p>
     * The event timestamp of the data lineage node.
     * </p>
     * 
     * @return The event timestamp of the data lineage node.
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The ID of the data lineage node.
     * </p>
     * 
     * @return The ID of the data lineage node.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageNodeReference)) {
            return false;
        }
        LineageNodeReference other = (LineageNodeReference) obj;
        return Objects.equals(eventTimestamp(), other.eventTimestamp()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageNodeReference").add("EventTimestamp", eventTimestamp()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageNodeReference, T> g) {
        return obj -> g.apply((LineageNodeReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageNodeReference> {
        /**
         * <p>
         * The event timestamp of the data lineage node.
         * </p>
         * 
         * @param eventTimestamp
         *        The event timestamp of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The ID of the data lineage node.
         * </p>
         * 
         * @param id
         *        The ID of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private Instant eventTimestamp;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageNodeReference model) {
            eventTimestamp(model.eventTimestamp);
            id(model.id);
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public LineageNodeReference build() {
            return new LineageNodeReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
