/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentProfilesRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListEnvironmentProfilesRequest.Builder, ListEnvironmentProfilesRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(ListEnvironmentProfilesRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(ListEnvironmentProfilesRequest::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountRegion").build())
            .build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListEnvironmentProfilesRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(ListEnvironmentProfilesRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnvironmentProfilesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListEnvironmentProfilesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(ListEnvironmentProfilesRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD,
            NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final String domainIdentifier;

    private final String environmentBlueprintIdentifier;

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final String projectIdentifier;

    private ListEnvironmentProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account where you want to list environment profiles.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account where you want to list environment profiles.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region where you want to list environment profiles.
     * </p>
     * 
     * @return The Amazon Web Services region where you want to list environment profiles.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the blueprint that was used to create the environment profiles that you want to list.
     * </p>
     * 
     * @return The identifier of the blueprint that was used to create the environment profiles that you want to list.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The maximum number of environment profiles to return in a single call to <code>ListEnvironmentProfiles</code>.
     * When the number of environment profiles to be listed is greater than the value of <code>MaxResults</code>, the
     * response contains a <code>NextToken</code> value that you can use in a subsequent call to
     * <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.
     * </p>
     * 
     * @return The maximum number of environment profiles to return in a single call to
     *         <code>ListEnvironmentProfiles</code>. When the number of environment profiles to be listed is greater
     *         than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you
     *         can use in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of environment
     *         profiles.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When the number of environment profiles is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * environment profiles, the response includes a pagination token named <code>NextToken</code>. You can specify this
     * <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of
     * environment profiles.
     * </p>
     * 
     * @return When the number of environment profiles is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of environment profiles, the response includes a pagination token named <code>NextToken</code>. You can
     *         specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentProfiles</code> to
     *         list the next set of environment profiles.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentProfilesRequest)) {
            return false;
        }
        ListEnvironmentProfilesRequest other = (ListEnvironmentProfilesRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(projectIdentifier(), other.projectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentProfilesRequest").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier()).add("MaxResults", maxResults())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("NextToken", nextToken())
                .add("ProjectIdentifier", projectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentProfilesRequest, T> g) {
        return obj -> g.apply((ListEnvironmentProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentProfilesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account where you want to list environment profiles.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier of the Amazon Web Services account where you want to list environment profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services region where you want to list environment profiles.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services region where you want to list environment profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the blueprint that was used to create the environment profiles that you want to list.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        The identifier of the blueprint that was used to create the environment profiles that you want to
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        /**
         * <p>
         * The maximum number of environment profiles to return in a single call to <code>ListEnvironmentProfiles</code>
         * . When the number of environment profiles to be listed is greater than the value of <code>MaxResults</code>,
         * the response contains a <code>NextToken</code> value that you can use in a subsequent call to
         * <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of environment profiles to return in a single call to
         *        <code>ListEnvironmentProfiles</code>. When the number of environment profiles to be listed is greater
         *        than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that
         *        you can use in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of
         *        environment profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p/>
         * 
         * @param name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the number of environment profiles is greater than the default value for the <code>MaxResults</code>
         * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * environment profiles, the response includes a pagination token named <code>NextToken</code>. You can specify
         * this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentProfiles</code> to list the
         * next set of environment profiles.
         * </p>
         * 
         * @param nextToken
         *        When the number of environment profiles is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of environment profiles, the response includes a pagination token named
         *        <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         *        <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the Amazon DataZone project.
         * </p>
         * 
         * @param projectIdentifier
         *        The identifier of the Amazon DataZone project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private String domainIdentifier;

        private String environmentBlueprintIdentifier;

        private Integer maxResults;

        private String name;

        private String nextToken;

        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentProfilesRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            domainIdentifier(model.domainIdentifier);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            projectIdentifier(model.projectIdentifier);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentProfilesRequest build() {
            return new ListEnvironmentProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
