/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostTimeSeriesDataPointsRequest extends DataZoneRequest implements
        ToCopyableBuilder<PostTimeSeriesDataPointsRequest.Builder, PostTimeSeriesDataPointsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PostTimeSeriesDataPointsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(PostTimeSeriesDataPointsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(PostTimeSeriesDataPointsRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(PostTimeSeriesDataPointsRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<List<TimeSeriesDataPointFormInput>> FORMS_FIELD = SdkField
            .<List<TimeSeriesDataPointFormInput>> builder(MarshallingType.LIST)
            .memberName("forms")
            .getter(getter(PostTimeSeriesDataPointsRequest::forms))
            .setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesDataPointFormInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesDataPointFormInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, FORMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final List<TimeSeriesDataPointFormInput> forms;

    private PostTimeSeriesDataPointsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.forms = builder.forms;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which you want to post time series data points.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the asset for which you want to post time series data points.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */
    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Forms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasForms() {
        return forms != null && !(forms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForms} method.
     * </p>
     * 
     * @return The forms that contain the data points that you want to post.
     */
    public final List<TimeSeriesDataPointFormInput> forms() {
        return forms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasForms() ? forms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTimeSeriesDataPointsRequest)) {
            return false;
        }
        PostTimeSeriesDataPointsRequest other = (PostTimeSeriesDataPointsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString()) && hasForms() == other.hasForms()
                && Objects.equals(forms(), other.forms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostTimeSeriesDataPointsRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("EntityIdentifier", entityIdentifier())
                .add("EntityType", entityTypeAsString()).add("Forms", hasForms() ? forms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("forms", FORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostTimeSeriesDataPointsRequest, T> g) {
        return obj -> g.apply((PostTimeSeriesDataPointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostTimeSeriesDataPointsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which you want to post time series data points.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which you want to post time series data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the asset for which you want to post time series data points.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the asset for which you want to post time series data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the asset for which you want to post data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to post data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset for which you want to post data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to post data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(TimeSeriesEntityType entityType);

        /**
         * <p>
         * The forms that contain the data points that you want to post.
         * </p>
         * 
         * @param forms
         *        The forms that contain the data points that you want to post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(Collection<TimeSeriesDataPointFormInput> forms);

        /**
         * <p>
         * The forms that contain the data points that you want to post.
         * </p>
         * 
         * @param forms
         *        The forms that contain the data points that you want to post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(TimeSeriesDataPointFormInput... forms);

        /**
         * <p>
         * The forms that contain the data points that you want to post.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormInput.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormInput.Builder#build()} is called
         * immediately and its result is passed to {@link #forms(List<TimeSeriesDataPointFormInput>)}.
         * 
         * @param forms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forms(java.util.Collection<TimeSeriesDataPointFormInput>)
         */
        Builder forms(Consumer<TimeSeriesDataPointFormInput.Builder>... forms);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private List<TimeSeriesDataPointFormInput> forms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostTimeSeriesDataPointsRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            forms(model.forms);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final List<TimeSeriesDataPointFormInput.Builder> getForms() {
            List<TimeSeriesDataPointFormInput.Builder> result = TimeSeriesDataPointFormInputListCopier.copyToBuilder(this.forms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForms(Collection<TimeSeriesDataPointFormInput.BuilderImpl> forms) {
            this.forms = TimeSeriesDataPointFormInputListCopier.copyFromBuilder(forms);
        }

        @Override
        public final Builder forms(Collection<TimeSeriesDataPointFormInput> forms) {
            this.forms = TimeSeriesDataPointFormInputListCopier.copy(forms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(TimeSeriesDataPointFormInput... forms) {
            forms(Arrays.asList(forms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(Consumer<TimeSeriesDataPointFormInput.Builder>... forms) {
            forms(Stream.of(forms).map(c -> TimeSeriesDataPointFormInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostTimeSeriesDataPointsRequest build() {
            return new PostTimeSeriesDataPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
