/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The project grant filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectGrantFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectGrantFilter.Builder, ProjectGrantFilter> {
    private static final SdkField<DomainUnitFilterForProject> DOMAIN_UNIT_FILTER_FIELD = SdkField
            .<DomainUnitFilterForProject> builder(MarshallingType.SDK_POJO).memberName("domainUnitFilter")
            .getter(getter(ProjectGrantFilter::domainUnitFilter)).setter(setter(Builder::domainUnitFilter))
            .constructor(DomainUnitFilterForProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainUnitFilterForProject domainUnitFilter;

    private final Type type;

    private ProjectGrantFilter(BuilderImpl builder) {
        this.domainUnitFilter = builder.domainUnitFilter;
        this.type = builder.type;
    }

    /**
     * <p>
     * The domain unit filter of the project grant filter.
     * </p>
     * 
     * @return The domain unit filter of the project grant filter.
     */
    public final DomainUnitFilterForProject domainUnitFilter() {
        return domainUnitFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectGrantFilter)) {
            return false;
        }
        ProjectGrantFilter other = (ProjectGrantFilter) obj;
        return Objects.equals(domainUnitFilter(), other.domainUnitFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectGrantFilter").add("DomainUnitFilter", domainUnitFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnitFilter":
            return Optional.ofNullable(clazz.cast(domainUnitFilter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #domainUnitFilter()} initialized to the given value.
     *
     * <p>
     * The domain unit filter of the project grant filter.
     * </p>
     * 
     * @param domainUnitFilter
     *        The domain unit filter of the project grant filter.
     */
    public static ProjectGrantFilter fromDomainUnitFilter(DomainUnitFilterForProject domainUnitFilter) {
        return builder().domainUnitFilter(domainUnitFilter).build();
    }

    /**
     * Create an instance of this class with {@link #domainUnitFilter()} initialized to the given value.
     *
     * <p>
     * The domain unit filter of the project grant filter.
     * </p>
     * 
     * @param domainUnitFilter
     *        The domain unit filter of the project grant filter.
     */
    public static ProjectGrantFilter fromDomainUnitFilter(Consumer<DomainUnitFilterForProject.Builder> domainUnitFilter) {
        DomainUnitFilterForProject.Builder builder = DomainUnitFilterForProject.builder();
        domainUnitFilter.accept(builder);
        return fromDomainUnitFilter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainUnitFilter", DOMAIN_UNIT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectGrantFilter, T> g) {
        return obj -> g.apply((ProjectGrantFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectGrantFilter> {
        /**
         * <p>
         * The domain unit filter of the project grant filter.
         * </p>
         * 
         * @param domainUnitFilter
         *        The domain unit filter of the project grant filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitFilter(DomainUnitFilterForProject domainUnitFilter);

        /**
         * <p>
         * The domain unit filter of the project grant filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitFilterForProject.Builder}
         * avoiding the need to create one manually via {@link DomainUnitFilterForProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitFilterForProject.Builder#build()} is called immediately
         * and its result is passed to {@link #domainUnitFilter(DomainUnitFilterForProject)}.
         * 
         * @param domainUnitFilter
         *        a consumer that will call methods on {@link DomainUnitFilterForProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainUnitFilter(DomainUnitFilterForProject)
         */
        default Builder domainUnitFilter(Consumer<DomainUnitFilterForProject.Builder> domainUnitFilter) {
            return domainUnitFilter(DomainUnitFilterForProject.builder().applyMutation(domainUnitFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainUnitFilterForProject domainUnitFilter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectGrantFilter model) {
            domainUnitFilter(model.domainUnitFilter);
        }

        public final DomainUnitFilterForProject.Builder getDomainUnitFilter() {
            return domainUnitFilter != null ? domainUnitFilter.toBuilder() : null;
        }

        public final void setDomainUnitFilter(DomainUnitFilterForProject.BuilderImpl domainUnitFilter) {
            Object oldValue = this.domainUnitFilter;
            this.domainUnitFilter = domainUnitFilter != null ? domainUnitFilter.build() : null;
            handleUnionValueChange(Type.DOMAIN_UNIT_FILTER, oldValue, this.domainUnitFilter);
        }

        @Override
        public final Builder domainUnitFilter(DomainUnitFilterForProject domainUnitFilter) {
            Object oldValue = this.domainUnitFilter;
            this.domainUnitFilter = domainUnitFilter;
            handleUnionValueChange(Type.DOMAIN_UNIT_FILTER, oldValue, this.domainUnitFilter);
            return this;
        }

        @Override
        public ProjectGrantFilter build() {
            return new ProjectGrantFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProjectGrantFilter#type()
     */
    public enum Type {
        DOMAIN_UNIT_FILTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
