/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Redshift properties patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftPropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftPropertiesPatch.Builder, RedshiftPropertiesPatch> {
    private static final SdkField<RedshiftCredentials> CREDENTIALS_FIELD = SdkField
            .<RedshiftCredentials> builder(MarshallingType.SDK_POJO).memberName("credentials")
            .getter(getter(RedshiftPropertiesPatch::credentials)).setter(setter(Builder::credentials))
            .constructor(RedshiftCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RedshiftPropertiesPatch::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("host")
            .getter(getter(RedshiftPropertiesPatch::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final SdkField<RedshiftLineageSyncConfigurationInput> LINEAGE_SYNC_FIELD = SdkField
            .<RedshiftLineageSyncConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("lineageSync")
            .getter(getter(RedshiftPropertiesPatch::lineageSync)).setter(setter(Builder::lineageSync))
            .constructor(RedshiftLineageSyncConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSync").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(RedshiftPropertiesPatch::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<RedshiftStorageProperties> STORAGE_FIELD = SdkField
            .<RedshiftStorageProperties> builder(MarshallingType.SDK_POJO).memberName("storage")
            .getter(getter(RedshiftPropertiesPatch::storage)).setter(setter(Builder::storage))
            .constructor(RedshiftStorageProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            DATABASE_NAME_FIELD, HOST_FIELD, LINEAGE_SYNC_FIELD, PORT_FIELD, STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftCredentials credentials;

    private final String databaseName;

    private final String host;

    private final RedshiftLineageSyncConfigurationInput lineageSync;

    private final Integer port;

    private final RedshiftStorageProperties storage;

    private RedshiftPropertiesPatch(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.databaseName = builder.databaseName;
        this.host = builder.host;
        this.lineageSync = builder.lineageSync;
        this.port = builder.port;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The credentials in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The credentials in the Amazon Redshift properties patch.
     */
    public final RedshiftCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The name in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The name in the Amazon Redshift properties patch.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The host in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The host in the Amazon Redshift properties patch.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The lineage sync in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The lineage sync in the Amazon Redshift properties patch.
     */
    public final RedshiftLineageSyncConfigurationInput lineageSync() {
        return lineageSync;
    }

    /**
     * <p>
     * The port in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The port in the Amazon Redshift properties patch.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The storage in the Amazon Redshift properties patch.
     * </p>
     * 
     * @return The storage in the Amazon Redshift properties patch.
     */
    public final RedshiftStorageProperties storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(lineageSync());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftPropertiesPatch)) {
            return false;
        }
        RedshiftPropertiesPatch other = (RedshiftPropertiesPatch) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(host(), other.host()) && Objects.equals(lineageSync(), other.lineageSync())
                && Objects.equals(port(), other.port()) && Objects.equals(storage(), other.storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftPropertiesPatch")
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DatabaseName", databaseName()).add("Host", host()).add("LineageSync", lineageSync()).add("Port", port())
                .add("Storage", storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        case "lineageSync":
            return Optional.ofNullable(clazz.cast(lineageSync()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("host", HOST_FIELD);
        map.put("lineageSync", LINEAGE_SYNC_FIELD);
        map.put("port", PORT_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftPropertiesPatch, T> g) {
        return obj -> g.apply((RedshiftPropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftPropertiesPatch> {
        /**
         * <p>
         * The credentials in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param credentials
         *        The credentials in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(RedshiftCredentials credentials);

        /**
         * <p>
         * The credentials in the Amazon Redshift properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftCredentials.Builder} avoiding the
         * need to create one manually via {@link RedshiftCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(RedshiftCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link RedshiftCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(RedshiftCredentials)
         */
        default Builder credentials(Consumer<RedshiftCredentials.Builder> credentials) {
            return credentials(RedshiftCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The name in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param databaseName
         *        The name in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The host in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param host
         *        The host in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The lineage sync in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param lineageSync
         *        The lineage sync in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageSync(RedshiftLineageSyncConfigurationInput lineageSync);

        /**
         * <p>
         * The lineage sync in the Amazon Redshift properties patch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftLineageSyncConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link RedshiftLineageSyncConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftLineageSyncConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #lineageSync(RedshiftLineageSyncConfigurationInput)}.
         * 
         * @param lineageSync
         *        a consumer that will call methods on {@link RedshiftLineageSyncConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageSync(RedshiftLineageSyncConfigurationInput)
         */
        default Builder lineageSync(Consumer<RedshiftLineageSyncConfigurationInput.Builder> lineageSync) {
            return lineageSync(RedshiftLineageSyncConfigurationInput.builder().applyMutation(lineageSync).build());
        }

        /**
         * <p>
         * The port in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param port
         *        The port in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The storage in the Amazon Redshift properties patch.
         * </p>
         * 
         * @param storage
         *        The storage in the Amazon Redshift properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(RedshiftStorageProperties storage);

        /**
         * <p>
         * The storage in the Amazon Redshift properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftStorageProperties.Builder}
         * avoiding the need to create one manually via {@link RedshiftStorageProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftStorageProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #storage(RedshiftStorageProperties)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link RedshiftStorageProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(RedshiftStorageProperties)
         */
        default Builder storage(Consumer<RedshiftStorageProperties.Builder> storage) {
            return storage(RedshiftStorageProperties.builder().applyMutation(storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftCredentials credentials;

        private String databaseName;

        private String host;

        private RedshiftLineageSyncConfigurationInput lineageSync;

        private Integer port;

        private RedshiftStorageProperties storage;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftPropertiesPatch model) {
            credentials(model.credentials);
            databaseName(model.databaseName);
            host(model.host);
            lineageSync(model.lineageSync);
            port(model.port);
            storage(model.storage);
        }

        public final RedshiftCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(RedshiftCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(RedshiftCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final RedshiftLineageSyncConfigurationInput.Builder getLineageSync() {
            return lineageSync != null ? lineageSync.toBuilder() : null;
        }

        public final void setLineageSync(RedshiftLineageSyncConfigurationInput.BuilderImpl lineageSync) {
            this.lineageSync = lineageSync != null ? lineageSync.build() : null;
        }

        @Override
        public final Builder lineageSync(RedshiftLineageSyncConfigurationInput lineageSync) {
            this.lineageSync = lineageSync;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final RedshiftStorageProperties.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(RedshiftStorageProperties.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(RedshiftStorageProperties storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public RedshiftPropertiesPatch build() {
            return new RedshiftPropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
