/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftStorage implements SdkPojo, Serializable, ToCopyableBuilder<RedshiftStorage.Builder, RedshiftStorage> {
    private static final SdkField<RedshiftClusterStorage> REDSHIFT_CLUSTER_SOURCE_FIELD = SdkField
            .<RedshiftClusterStorage> builder(MarshallingType.SDK_POJO).memberName("redshiftClusterSource")
            .getter(getter(RedshiftStorage::redshiftClusterSource)).setter(setter(Builder::redshiftClusterSource))
            .constructor(RedshiftClusterStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftClusterSource").build())
            .build();

    private static final SdkField<RedshiftServerlessStorage> REDSHIFT_SERVERLESS_SOURCE_FIELD = SdkField
            .<RedshiftServerlessStorage> builder(MarshallingType.SDK_POJO).memberName("redshiftServerlessSource")
            .getter(getter(RedshiftStorage::redshiftServerlessSource)).setter(setter(Builder::redshiftServerlessSource))
            .constructor(RedshiftServerlessStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftServerlessSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_CLUSTER_SOURCE_FIELD,
            REDSHIFT_SERVERLESS_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftClusterStorage redshiftClusterSource;

    private final RedshiftServerlessStorage redshiftServerlessSource;

    private final Type type;

    private RedshiftStorage(BuilderImpl builder) {
        this.redshiftClusterSource = builder.redshiftClusterSource;
        this.redshiftServerlessSource = builder.redshiftServerlessSource;
        this.type = builder.type;
    }

    /**
     * <p>
     * The details of the Amazon Redshift cluster source.
     * </p>
     * 
     * @return The details of the Amazon Redshift cluster source.
     */
    public final RedshiftClusterStorage redshiftClusterSource() {
        return redshiftClusterSource;
    }

    /**
     * <p>
     * The details of the Amazon Redshift Serverless workgroup source.
     * </p>
     * 
     * @return The details of the Amazon Redshift Serverless workgroup source.
     */
    public final RedshiftServerlessStorage redshiftServerlessSource() {
        return redshiftServerlessSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshiftClusterSource());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftServerlessSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftStorage)) {
            return false;
        }
        RedshiftStorage other = (RedshiftStorage) obj;
        return Objects.equals(redshiftClusterSource(), other.redshiftClusterSource())
                && Objects.equals(redshiftServerlessSource(), other.redshiftServerlessSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftStorage").add("RedshiftClusterSource", redshiftClusterSource())
                .add("RedshiftServerlessSource", redshiftServerlessSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "redshiftClusterSource":
            return Optional.ofNullable(clazz.cast(redshiftClusterSource()));
        case "redshiftServerlessSource":
            return Optional.ofNullable(clazz.cast(redshiftServerlessSource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #redshiftClusterSource()} initialized to the given value.
     *
     * <p>
     * The details of the Amazon Redshift cluster source.
     * </p>
     * 
     * @param redshiftClusterSource
     *        The details of the Amazon Redshift cluster source.
     */
    public static RedshiftStorage fromRedshiftClusterSource(RedshiftClusterStorage redshiftClusterSource) {
        return builder().redshiftClusterSource(redshiftClusterSource).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftClusterSource()} initialized to the given value.
     *
     * <p>
     * The details of the Amazon Redshift cluster source.
     * </p>
     * 
     * @param redshiftClusterSource
     *        The details of the Amazon Redshift cluster source.
     */
    public static RedshiftStorage fromRedshiftClusterSource(Consumer<RedshiftClusterStorage.Builder> redshiftClusterSource) {
        RedshiftClusterStorage.Builder builder = RedshiftClusterStorage.builder();
        redshiftClusterSource.accept(builder);
        return fromRedshiftClusterSource(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftServerlessSource()} initialized to the given value.
     *
     * <p>
     * The details of the Amazon Redshift Serverless workgroup source.
     * </p>
     * 
     * @param redshiftServerlessSource
     *        The details of the Amazon Redshift Serverless workgroup source.
     */
    public static RedshiftStorage fromRedshiftServerlessSource(RedshiftServerlessStorage redshiftServerlessSource) {
        return builder().redshiftServerlessSource(redshiftServerlessSource).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftServerlessSource()} initialized to the given value.
     *
     * <p>
     * The details of the Amazon Redshift Serverless workgroup source.
     * </p>
     * 
     * @param redshiftServerlessSource
     *        The details of the Amazon Redshift Serverless workgroup source.
     */
    public static RedshiftStorage fromRedshiftServerlessSource(
            Consumer<RedshiftServerlessStorage.Builder> redshiftServerlessSource) {
        RedshiftServerlessStorage.Builder builder = RedshiftServerlessStorage.builder();
        redshiftServerlessSource.accept(builder);
        return fromRedshiftServerlessSource(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("redshiftClusterSource", REDSHIFT_CLUSTER_SOURCE_FIELD);
        map.put("redshiftServerlessSource", REDSHIFT_SERVERLESS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftStorage, T> g) {
        return obj -> g.apply((RedshiftStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftStorage> {
        /**
         * <p>
         * The details of the Amazon Redshift cluster source.
         * </p>
         * 
         * @param redshiftClusterSource
         *        The details of the Amazon Redshift cluster source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftClusterSource(RedshiftClusterStorage redshiftClusterSource);

        /**
         * <p>
         * The details of the Amazon Redshift cluster source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftClusterStorage.Builder} avoiding
         * the need to create one manually via {@link RedshiftClusterStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftClusterStorage.Builder#build()} is called immediately and
         * its result is passed to {@link #redshiftClusterSource(RedshiftClusterStorage)}.
         * 
         * @param redshiftClusterSource
         *        a consumer that will call methods on {@link RedshiftClusterStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftClusterSource(RedshiftClusterStorage)
         */
        default Builder redshiftClusterSource(Consumer<RedshiftClusterStorage.Builder> redshiftClusterSource) {
            return redshiftClusterSource(RedshiftClusterStorage.builder().applyMutation(redshiftClusterSource).build());
        }

        /**
         * <p>
         * The details of the Amazon Redshift Serverless workgroup source.
         * </p>
         * 
         * @param redshiftServerlessSource
         *        The details of the Amazon Redshift Serverless workgroup source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftServerlessSource(RedshiftServerlessStorage redshiftServerlessSource);

        /**
         * <p>
         * The details of the Amazon Redshift Serverless workgroup source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftServerlessStorage.Builder}
         * avoiding the need to create one manually via {@link RedshiftServerlessStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftServerlessStorage.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftServerlessSource(RedshiftServerlessStorage)}.
         * 
         * @param redshiftServerlessSource
         *        a consumer that will call methods on {@link RedshiftServerlessStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftServerlessSource(RedshiftServerlessStorage)
         */
        default Builder redshiftServerlessSource(Consumer<RedshiftServerlessStorage.Builder> redshiftServerlessSource) {
            return redshiftServerlessSource(RedshiftServerlessStorage.builder().applyMutation(redshiftServerlessSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftClusterStorage redshiftClusterSource;

        private RedshiftServerlessStorage redshiftServerlessSource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftStorage model) {
            redshiftClusterSource(model.redshiftClusterSource);
            redshiftServerlessSource(model.redshiftServerlessSource);
        }

        public final RedshiftClusterStorage.Builder getRedshiftClusterSource() {
            return redshiftClusterSource != null ? redshiftClusterSource.toBuilder() : null;
        }

        public final void setRedshiftClusterSource(RedshiftClusterStorage.BuilderImpl redshiftClusterSource) {
            Object oldValue = this.redshiftClusterSource;
            this.redshiftClusterSource = redshiftClusterSource != null ? redshiftClusterSource.build() : null;
            handleUnionValueChange(Type.REDSHIFT_CLUSTER_SOURCE, oldValue, this.redshiftClusterSource);
        }

        @Override
        public final Builder redshiftClusterSource(RedshiftClusterStorage redshiftClusterSource) {
            Object oldValue = this.redshiftClusterSource;
            this.redshiftClusterSource = redshiftClusterSource;
            handleUnionValueChange(Type.REDSHIFT_CLUSTER_SOURCE, oldValue, this.redshiftClusterSource);
            return this;
        }

        public final RedshiftServerlessStorage.Builder getRedshiftServerlessSource() {
            return redshiftServerlessSource != null ? redshiftServerlessSource.toBuilder() : null;
        }

        public final void setRedshiftServerlessSource(RedshiftServerlessStorage.BuilderImpl redshiftServerlessSource) {
            Object oldValue = this.redshiftServerlessSource;
            this.redshiftServerlessSource = redshiftServerlessSource != null ? redshiftServerlessSource.build() : null;
            handleUnionValueChange(Type.REDSHIFT_SERVERLESS_SOURCE, oldValue, this.redshiftServerlessSource);
        }

        @Override
        public final Builder redshiftServerlessSource(RedshiftServerlessStorage redshiftServerlessSource) {
            Object oldValue = this.redshiftServerlessSource;
            this.redshiftServerlessSource = redshiftServerlessSource;
            handleUnionValueChange(Type.REDSHIFT_SERVERLESS_SOURCE, oldValue, this.redshiftServerlessSource);
            return this;
        }

        @Override
        public RedshiftStorage build() {
            return new RedshiftStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RedshiftStorage#type()
     */
    public enum Type {
        REDSHIFT_CLUSTER_SOURCE,

        REDSHIFT_SERVERLESS_SOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
