/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the automatically generated business metadata that is rejected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectChoice implements SdkPojo, Serializable, ToCopyableBuilder<RejectChoice.Builder, RejectChoice> {
    private static final SdkField<List<Integer>> PREDICTION_CHOICES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("predictionChoices")
            .getter(getter(RejectChoice::predictionChoices))
            .setter(setter(Builder::predictionChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREDICTION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("predictionTarget").getter(getter(RejectChoice::predictionTarget))
            .setter(setter(Builder::predictionTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTION_CHOICES_FIELD,
            PREDICTION_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Integer> predictionChoices;

    private final String predictionTarget;

    private RejectChoice(BuilderImpl builder) {
        this.predictionChoices = builder.predictionChoices;
        this.predictionTarget = builder.predictionTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the PredictionChoices property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPredictionChoices() {
        return predictionChoices != null && !(predictionChoices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the the automatically generated business metadata that can be rejected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredictionChoices} method.
     * </p>
     * 
     * @return Specifies the the automatically generated business metadata that can be rejected.
     */
    public final List<Integer> predictionChoices() {
        return predictionChoices;
    }

    /**
     * <p>
     * Specifies the target (for example, a column name) where a prediction can be rejected.
     * </p>
     * 
     * @return Specifies the target (for example, a column name) where a prediction can be rejected.
     */
    public final String predictionTarget() {
        return predictionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictionChoices() ? predictionChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predictionTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectChoice)) {
            return false;
        }
        RejectChoice other = (RejectChoice) obj;
        return hasPredictionChoices() == other.hasPredictionChoices()
                && Objects.equals(predictionChoices(), other.predictionChoices())
                && Objects.equals(predictionTarget(), other.predictionTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectChoice").add("PredictionChoices", hasPredictionChoices() ? predictionChoices() : null)
                .add("PredictionTarget", predictionTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "predictionChoices":
            return Optional.ofNullable(clazz.cast(predictionChoices()));
        case "predictionTarget":
            return Optional.ofNullable(clazz.cast(predictionTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("predictionChoices", PREDICTION_CHOICES_FIELD);
        map.put("predictionTarget", PREDICTION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectChoice, T> g) {
        return obj -> g.apply((RejectChoice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectChoice> {
        /**
         * <p>
         * Specifies the the automatically generated business metadata that can be rejected.
         * </p>
         * 
         * @param predictionChoices
         *        Specifies the the automatically generated business metadata that can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionChoices(Collection<Integer> predictionChoices);

        /**
         * <p>
         * Specifies the the automatically generated business metadata that can be rejected.
         * </p>
         * 
         * @param predictionChoices
         *        Specifies the the automatically generated business metadata that can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionChoices(Integer... predictionChoices);

        /**
         * <p>
         * Specifies the target (for example, a column name) where a prediction can be rejected.
         * </p>
         * 
         * @param predictionTarget
         *        Specifies the target (for example, a column name) where a prediction can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTarget(String predictionTarget);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> predictionChoices = DefaultSdkAutoConstructList.getInstance();

        private String predictionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectChoice model) {
            predictionChoices(model.predictionChoices);
            predictionTarget(model.predictionTarget);
        }

        public final Collection<Integer> getPredictionChoices() {
            if (predictionChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return predictionChoices;
        }

        public final void setPredictionChoices(Collection<Integer> predictionChoices) {
            this.predictionChoices = PredictionChoicesCopier.copy(predictionChoices);
        }

        @Override
        public final Builder predictionChoices(Collection<Integer> predictionChoices) {
            this.predictionChoices = PredictionChoicesCopier.copy(predictionChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictionChoices(Integer... predictionChoices) {
            predictionChoices(Arrays.asList(predictionChoices));
            return this;
        }

        public final String getPredictionTarget() {
            return predictionTarget;
        }

        public final void setPredictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
        }

        @Override
        public final Builder predictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
            return this;
        }

        @Override
        public RejectChoice build() {
            return new RejectChoice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
