/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<RuleSummary.Builder, RuleSummary> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(RuleSummary::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(RuleSummary::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(RuleSummary::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RuleSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(RuleSummary::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleType").getter(getter(RuleSummary::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()).build();

    private static final SdkField<RuleScope> SCOPE_FIELD = SdkField.<RuleScope> builder(MarshallingType.SDK_POJO)
            .memberName("scope").getter(getter(RuleSummary::scope)).setter(setter(Builder::scope))
            .constructor(RuleScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<RuleTarget> TARGET_FIELD = SdkField.<RuleTarget> builder(MarshallingType.SDK_POJO)
            .memberName("target").getter(getter(RuleSummary::target)).setter(setter(Builder::target))
            .constructor(RuleTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(RuleSummary::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(RuleSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            IDENTIFIER_FIELD, LAST_UPDATED_BY_FIELD, NAME_FIELD, REVISION_FIELD, RULE_TYPE_FIELD, SCOPE_FIELD, TARGET_FIELD,
            TARGET_TYPE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String identifier;

    private final String lastUpdatedBy;

    private final String name;

    private final String revision;

    private final String ruleType;

    private final RuleScope scope;

    private final RuleTarget target;

    private final String targetType;

    private final Instant updatedAt;

    private RuleSummary(BuilderImpl builder) {
        this.action = builder.action;
        this.identifier = builder.identifier;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.name = builder.name;
        this.revision = builder.revision;
        this.ruleType = builder.ruleType;
        this.scope = builder.scope;
        this.target = builder.target;
        this.targetType = builder.targetType;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final RuleAction action() {
        return RuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The ID of the rule.
     * </p>
     * 
     * @return The ID of the rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The timestamp at which the rule was last updated.
     * </p>
     * 
     * @return The timestamp at which the rule was last updated.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The revision of the rule.
     * </p>
     * 
     * @return The revision of the rule.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final RuleType ruleType() {
        return RuleType.fromValue(ruleType);
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final String ruleTypeAsString() {
        return ruleType;
    }

    /**
     * <p>
     * The scope of the rule.
     * </p>
     * 
     * @return The scope of the rule.
     */
    public final RuleScope scope() {
        return scope;
    }

    /**
     * <p>
     * The target of the rule.
     * </p>
     * 
     * @return The target of the rule.
     */
    public final RuleTarget target() {
        return target;
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final RuleTargetType targetType() {
        return RuleTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The timestamp at which the rule was last updated.
     * </p>
     * 
     * @return The timestamp at which the rule was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(name(), other.name())
                && Objects.equals(revision(), other.revision()) && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString())
                && Objects.equals(scope(), other.scope()) && Objects.equals(target(), other.target())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSummary").add("Action", actionAsString()).add("Identifier", identifier())
                .add("LastUpdatedBy", lastUpdatedBy()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Revision", revision()).add("RuleType", ruleTypeAsString()).add("Scope", scope()).add("Target", target())
                .add("TargetType", targetTypeAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "ruleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSummary> {
        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * The ID of the rule.
         * </p>
         * 
         * @param identifier
         *        The ID of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The timestamp at which the rule was last updated.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The timestamp at which the rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The revision of the rule.
         * </p>
         * 
         * @param revision
         *        The revision of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(RuleType ruleType);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * 
         * @param scope
         *        The scope of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(RuleScope scope);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleScope.Builder} avoiding the need to
         * create one manually via {@link RuleScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleScope.Builder#build()} is called immediately and its result
         * is passed to {@link #scope(RuleScope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link RuleScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(RuleScope)
         */
        default Builder scope(Consumer<RuleScope.Builder> scope) {
            return scope(RuleScope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The target of the rule.
         * </p>
         * 
         * @param target
         *        The target of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(RuleTarget target);

        /**
         * <p>
         * The target of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTarget.Builder} avoiding the need to
         * create one manually via {@link RuleTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #target(RuleTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link RuleTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(RuleTarget)
         */
        default Builder target(Consumer<RuleTarget.Builder> target) {
            return target(RuleTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(RuleTargetType targetType);

        /**
         * <p>
         * The timestamp at which the rule was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String identifier;

        private String lastUpdatedBy;

        private String name;

        private String revision;

        private String ruleType;

        private RuleScope scope;

        private RuleTarget target;

        private String targetType;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            action(model.action);
            identifier(model.identifier);
            lastUpdatedBy(model.lastUpdatedBy);
            name(model.name);
            revision(model.revision);
            ruleType(model.ruleType);
            scope(model.scope);
            target(model.target);
            targetType(model.targetType);
            updatedAt(model.updatedAt);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getRuleType() {
            return ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final RuleScope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(RuleScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(RuleScope scope) {
            this.scope = scope;
            return this;
        }

        public final RuleTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(RuleTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(RuleTarget target) {
            this.target = target;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RuleTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public RuleSummary build() {
            return new RuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
