/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The published asset for which the subscription grant is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedListingItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedListingItem.Builder, SubscribedListingItem> {
    private static final SdkField<SubscribedAssetListing> ASSET_LISTING_FIELD = SdkField
            .<SubscribedAssetListing> builder(MarshallingType.SDK_POJO).memberName("assetListing")
            .getter(getter(SubscribedListingItem::assetListing)).setter(setter(Builder::assetListing))
            .constructor(SubscribedAssetListing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListing").build()).build();

    private static final SdkField<SubscribedProductListing> PRODUCT_LISTING_FIELD = SdkField
            .<SubscribedProductListing> builder(MarshallingType.SDK_POJO).memberName("productListing")
            .getter(getter(SubscribedListingItem::productListing)).setter(setter(Builder::productListing))
            .constructor(SubscribedProductListing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productListing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTING_FIELD,
            PRODUCT_LISTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SubscribedAssetListing assetListing;

    private final SubscribedProductListing productListing;

    private final Type type;

    private SubscribedListingItem(BuilderImpl builder) {
        this.assetListing = builder.assetListing;
        this.productListing = builder.productListing;
        this.type = builder.type;
    }

    /**
     * <p>
     * The asset for which the subscription grant is created.
     * </p>
     * 
     * @return The asset for which the subscription grant is created.
     */
    public final SubscribedAssetListing assetListing() {
        return assetListing;
    }

    /**
     * <p>
     * The data product listing.
     * </p>
     * 
     * @return The data product listing.
     */
    public final SubscribedProductListing productListing() {
        return productListing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetListing());
        hashCode = 31 * hashCode + Objects.hashCode(productListing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedListingItem)) {
            return false;
        }
        SubscribedListingItem other = (SubscribedListingItem) obj;
        return Objects.equals(assetListing(), other.assetListing()) && Objects.equals(productListing(), other.productListing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedListingItem").add("AssetListing", assetListing())
                .add("ProductListing", productListing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetListing":
            return Optional.ofNullable(clazz.cast(assetListing()));
        case "productListing":
            return Optional.ofNullable(clazz.cast(productListing()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #assetListing()} initialized to the given value.
     *
     * <p>
     * The asset for which the subscription grant is created.
     * </p>
     * 
     * @param assetListing
     *        The asset for which the subscription grant is created.
     */
    public static SubscribedListingItem fromAssetListing(SubscribedAssetListing assetListing) {
        return builder().assetListing(assetListing).build();
    }

    /**
     * Create an instance of this class with {@link #assetListing()} initialized to the given value.
     *
     * <p>
     * The asset for which the subscription grant is created.
     * </p>
     * 
     * @param assetListing
     *        The asset for which the subscription grant is created.
     */
    public static SubscribedListingItem fromAssetListing(Consumer<SubscribedAssetListing.Builder> assetListing) {
        SubscribedAssetListing.Builder builder = SubscribedAssetListing.builder();
        assetListing.accept(builder);
        return fromAssetListing(builder.build());
    }

    /**
     * Create an instance of this class with {@link #productListing()} initialized to the given value.
     *
     * <p>
     * The data product listing.
     * </p>
     * 
     * @param productListing
     *        The data product listing.
     */
    public static SubscribedListingItem fromProductListing(SubscribedProductListing productListing) {
        return builder().productListing(productListing).build();
    }

    /**
     * Create an instance of this class with {@link #productListing()} initialized to the given value.
     *
     * <p>
     * The data product listing.
     * </p>
     * 
     * @param productListing
     *        The data product listing.
     */
    public static SubscribedListingItem fromProductListing(Consumer<SubscribedProductListing.Builder> productListing) {
        SubscribedProductListing.Builder builder = SubscribedProductListing.builder();
        productListing.accept(builder);
        return fromProductListing(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetListing", ASSET_LISTING_FIELD);
        map.put("productListing", PRODUCT_LISTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedListingItem, T> g) {
        return obj -> g.apply((SubscribedListingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedListingItem> {
        /**
         * <p>
         * The asset for which the subscription grant is created.
         * </p>
         * 
         * @param assetListing
         *        The asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetListing(SubscribedAssetListing assetListing);

        /**
         * <p>
         * The asset for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedAssetListing.Builder} avoiding
         * the need to create one manually via {@link SubscribedAssetListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedAssetListing.Builder#build()} is called immediately and
         * its result is passed to {@link #assetListing(SubscribedAssetListing)}.
         * 
         * @param assetListing
         *        a consumer that will call methods on {@link SubscribedAssetListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetListing(SubscribedAssetListing)
         */
        default Builder assetListing(Consumer<SubscribedAssetListing.Builder> assetListing) {
            return assetListing(SubscribedAssetListing.builder().applyMutation(assetListing).build());
        }

        /**
         * <p>
         * The data product listing.
         * </p>
         * 
         * @param productListing
         *        The data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productListing(SubscribedProductListing productListing);

        /**
         * <p>
         * The data product listing.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedProductListing.Builder}
         * avoiding the need to create one manually via {@link SubscribedProductListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedProductListing.Builder#build()} is called immediately
         * and its result is passed to {@link #productListing(SubscribedProductListing)}.
         * 
         * @param productListing
         *        a consumer that will call methods on {@link SubscribedProductListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productListing(SubscribedProductListing)
         */
        default Builder productListing(Consumer<SubscribedProductListing.Builder> productListing) {
            return productListing(SubscribedProductListing.builder().applyMutation(productListing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SubscribedAssetListing assetListing;

        private SubscribedProductListing productListing;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedListingItem model) {
            assetListing(model.assetListing);
            productListing(model.productListing);
        }

        public final SubscribedAssetListing.Builder getAssetListing() {
            return assetListing != null ? assetListing.toBuilder() : null;
        }

        public final void setAssetListing(SubscribedAssetListing.BuilderImpl assetListing) {
            Object oldValue = this.assetListing;
            this.assetListing = assetListing != null ? assetListing.build() : null;
            handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
        }

        @Override
        public final Builder assetListing(SubscribedAssetListing assetListing) {
            Object oldValue = this.assetListing;
            this.assetListing = assetListing;
            handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
            return this;
        }

        public final SubscribedProductListing.Builder getProductListing() {
            return productListing != null ? productListing.toBuilder() : null;
        }

        public final void setProductListing(SubscribedProductListing.BuilderImpl productListing) {
            Object oldValue = this.productListing;
            this.productListing = productListing != null ? productListing.build() : null;
            handleUnionValueChange(Type.PRODUCT_LISTING, oldValue, this.productListing);
        }

        @Override
        public final Builder productListing(SubscribedProductListing productListing) {
            Object oldValue = this.productListing;
            this.productListing = productListing;
            handleUnionValueChange(Type.PRODUCT_LISTING, oldValue, this.productListing);
            return this;
        }

        @Override
        public SubscribedListingItem build() {
            return new SubscribedListingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SubscribedListingItem#type()
     */
    public enum Type {
        ASSET_LISTING,

        PRODUCT_LISTING,

        UNKNOWN_TO_SDK_VERSION
    }
}
