/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<List<FormInput>> ASSET_FORMS_INPUT_FIELD = SdkField
            .<List<FormInput>> builder(MarshallingType.LIST)
            .memberName("assetFormsInput")
            .getter(getter(UpdateDataSourceRequest::assetFormsInput))
            .setter(setter(Builder::assetFormsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsInput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceConfigurationInput> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateDataSourceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateDataSourceRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enableSetting").getter(getter(UpdateDataSourceRequest::enableSettingAsString))
            .setter(setter(Builder::enableSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateDataSourceRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publishOnImport").getter(getter(UpdateDataSourceRequest::publishOnImport))
            .setter(setter(Builder::publishOnImport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()).build();

    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField
            .<RecommendationConfiguration> builder(MarshallingType.SDK_POJO).memberName("recommendation")
            .getter(getter(UpdateDataSourceRequest::recommendation)).setter(setter(Builder::recommendation))
            .constructor(RecommendationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<Boolean> RETAIN_PERMISSIONS_ON_REVOKE_FAILURE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("retainPermissionsOnRevokeFailure")
            .getter(getter(UpdateDataSourceRequest::retainPermissionsOnRevokeFailure))
            .setter(setter(Builder::retainPermissionsOnRevokeFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainPermissionsOnRevokeFailure")
                    .build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(UpdateDataSourceRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_INPUT_FIELD,
            CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENABLE_SETTING_FIELD, IDENTIFIER_FIELD, NAME_FIELD,
            PUBLISH_ON_IMPORT_FIELD, RECOMMENDATION_FIELD, RETAIN_PERMISSIONS_ON_REVOKE_FAILURE_FIELD, SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FormInput> assetFormsInput;

    private final DataSourceConfigurationInput configuration;

    private final String description;

    private final String domainIdentifier;

    private final String enableSetting;

    private final String identifier;

    private final String name;

    private final Boolean publishOnImport;

    private final RecommendationConfiguration recommendation;

    private final Boolean retainPermissionsOnRevokeFailure;

    private final ScheduleConfiguration schedule;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.assetFormsInput = builder.assetFormsInput;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.enableSetting = builder.enableSetting;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.retainPermissionsOnRevokeFailure = builder.retainPermissionsOnRevokeFailure;
        this.schedule = builder.schedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetFormsInput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetFormsInput() {
        return assetFormsInput != null && !(assetFormsInput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetFormsInput} method.
     * </p>
     * 
     * @return The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final List<FormInput> assetFormsInput() {
        return assetFormsInput;
    }

    /**
     * <p>
     * The configuration to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The configuration to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final DataSourceConfigurationInput configuration() {
        return configuration;
    }

    /**
     * <p>
     * The description to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The description to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the domain in which to update a data source.
     * </p>
     * 
     * @return The identifier of the domain in which to update a data source.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
     * @see EnableSetting
     */
    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(enableSetting);
    }

    /**
     * <p>
     * The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
     * @see EnableSetting
     */
    public final String enableSettingAsString() {
        return enableSetting;
    }

    /**
     * <p>
     * The identifier of the data source to be updated.
     * </p>
     * 
     * @return The identifier of the data source to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final Boolean publishOnImport() {
        return publishOnImport;
    }

    /**
     * <p>
     * The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final RecommendationConfiguration recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a data
     * source.
     * </p>
     * 
     * @return Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for
     *         a data source.
     */
    public final Boolean retainPermissionsOnRevokeFailure() {
        return retainPermissionsOnRevokeFailure;
    }

    /**
     * <p>
     * The schedule to be updated as part of the <code>UpdateDataSource</code> action.
     * </p>
     * 
     * @return The schedule to be updated as part of the <code>UpdateDataSource</code> action.
     */
    public final ScheduleConfiguration schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetFormsInput() ? assetFormsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(retainPermissionsOnRevokeFailure());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return hasAssetFormsInput() == other.hasAssetFormsInput() && Objects.equals(assetFormsInput(), other.assetFormsInput())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(enableSettingAsString(), other.enableSettingAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(publishOnImport(), other.publishOnImport())
                && Objects.equals(recommendation(), other.recommendation())
                && Objects.equals(retainPermissionsOnRevokeFailure(), other.retainPermissionsOnRevokeFailure())
                && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourceRequest")
                .add("AssetFormsInput", assetFormsInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Configuration", configuration())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("EnableSetting", enableSettingAsString())
                .add("Identifier", identifier()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PublishOnImport", publishOnImport()).add("Recommendation", recommendation())
                .add("RetainPermissionsOnRevokeFailure", retainPermissionsOnRevokeFailure())
                .add("Schedule", schedule() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetFormsInput":
            return Optional.ofNullable(clazz.cast(assetFormsInput()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "enableSetting":
            return Optional.ofNullable(clazz.cast(enableSettingAsString()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "publishOnImport":
            return Optional.ofNullable(clazz.cast(publishOnImport()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "retainPermissionsOnRevokeFailure":
            return Optional.ofNullable(clazz.cast(retainPermissionsOnRevokeFailure()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetFormsInput", ASSET_FORMS_INPUT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("enableSetting", ENABLE_SETTING_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("publishOnImport", PUBLISH_ON_IMPORT_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("retainPermissionsOnRevokeFailure", RETAIN_PERMISSIONS_ON_REVOKE_FAILURE_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param assetFormsInput
         *        The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsInput(Collection<FormInput> assetFormsInput);

        /**
         * <p>
         * The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param assetFormsInput
         *        The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsInput(FormInput... assetFormsInput);

        /**
         * <p>
         * The asset forms to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder#build()} is called immediately and
         * its result is passed to {@link #assetFormsInput(List<FormInput>)}.
         * 
         * @param assetFormsInput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetFormsInput(java.util.Collection<FormInput>)
         */
        Builder assetFormsInput(Consumer<FormInput.Builder>... assetFormsInput);

        /**
         * <p>
         * The configuration to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param configuration
         *        The configuration to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfigurationInput configuration);

        /**
         * <p>
         * The configuration to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(DataSourceConfigurationInput)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfigurationInput)
         */
        default Builder configuration(Consumer<DataSourceConfigurationInput.Builder> configuration) {
            return configuration(DataSourceConfigurationInput.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The description to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param description
         *        The description to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the domain in which to update a data source.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the domain in which to update a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param enableSetting
         *        The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(String enableSetting);

        /**
         * <p>
         * The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param enableSetting
         *        The enable setting to be updated as part of the <code>UpdateDataSource</code> action.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(EnableSetting enableSetting);

        /**
         * <p>
         * The identifier of the data source to be updated.
         * </p>
         * 
         * @param identifier
         *        The identifier of the data source to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param publishOnImport
         *        The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishOnImport(Boolean publishOnImport);

        /**
         * <p>
         * The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param recommendation
         *        The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(RecommendationConfiguration recommendation);

        /**
         * <p>
         * The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RecommendationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendation(RecommendationConfiguration)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link RecommendationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(RecommendationConfiguration)
         */
        default Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return recommendation(RecommendationConfiguration.builder().applyMutation(recommendation).build());
        }

        /**
         * <p>
         * Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a
         * data source.
         * </p>
         * 
         * @param retainPermissionsOnRevokeFailure
         *        Specifies that the granted permissions are retained in case of a self-subscribe functionality failure
         *        for a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainPermissionsOnRevokeFailure(Boolean retainPermissionsOnRevokeFailure);

        /**
         * <p>
         * The schedule to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * 
         * @param schedule
         *        The schedule to be updated as part of the <code>UpdateDataSource</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ScheduleConfiguration schedule);

        /**
         * <p>
         * The schedule to be updated as part of the <code>UpdateDataSource</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(ScheduleConfiguration)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(ScheduleConfiguration)
         */
        default Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return schedule(ScheduleConfiguration.builder().applyMutation(schedule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<FormInput> assetFormsInput = DefaultSdkAutoConstructList.getInstance();

        private DataSourceConfigurationInput configuration;

        private String description;

        private String domainIdentifier;

        private String enableSetting;

        private String identifier;

        private String name;

        private Boolean publishOnImport;

        private RecommendationConfiguration recommendation;

        private Boolean retainPermissionsOnRevokeFailure;

        private ScheduleConfiguration schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            assetFormsInput(model.assetFormsInput);
            configuration(model.configuration);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            enableSetting(model.enableSetting);
            identifier(model.identifier);
            name(model.name);
            publishOnImport(model.publishOnImport);
            recommendation(model.recommendation);
            retainPermissionsOnRevokeFailure(model.retainPermissionsOnRevokeFailure);
            schedule(model.schedule);
        }

        public final List<FormInput.Builder> getAssetFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.assetFormsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsInput(Collection<FormInput.BuilderImpl> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copyFromBuilder(assetFormsInput);
        }

        @Override
        public final Builder assetFormsInput(Collection<FormInput> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copy(assetFormsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(FormInput... assetFormsInput) {
            assetFormsInput(Arrays.asList(assetFormsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(Consumer<FormInput.Builder>... assetFormsInput) {
            assetFormsInput(Stream.of(assetFormsInput).map(c -> FormInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataSourceConfigurationInput.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationInput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationInput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnableSetting() {
            return enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final Boolean getRetainPermissionsOnRevokeFailure() {
            return retainPermissionsOnRevokeFailure;
        }

        public final void setRetainPermissionsOnRevokeFailure(Boolean retainPermissionsOnRevokeFailure) {
            this.retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure;
        }

        @Override
        public final Builder retainPermissionsOnRevokeFailure(Boolean retainPermissionsOnRevokeFailure) {
            this.retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
