/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupProfileResponse extends DataZoneResponse implements
        ToCopyableBuilder<UpdateGroupProfileResponse.Builder, UpdateGroupProfileResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(UpdateGroupProfileResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(UpdateGroupProfileResponse::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateGroupProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateGroupProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            GROUP_NAME_FIELD, ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final String groupName;

    private final String id;

    private final String status;

    private UpdateGroupProfileResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.groupName = builder.groupName;
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a group profile is updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a group profile is updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the group profile that is updated.
     * </p>
     * 
     * @return The name of the group profile that is updated.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The identifier of the group profile that is updated.
     * </p>
     * 
     * @return The identifier of the group profile that is updated.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the group profile that is updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the group profile that is updated.
     * @see GroupProfileStatus
     */
    public final GroupProfileStatus status() {
        return GroupProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the group profile that is updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the group profile that is updated.
     * @see GroupProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupProfileResponse)) {
            return false;
        }
        UpdateGroupProfileResponse other = (UpdateGroupProfileResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupProfileResponse").add("DomainId", domainId())
                .add("GroupName", groupName() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("groupName", GROUP_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupProfileResponse, T> g) {
        return obj -> g.apply((UpdateGroupProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGroupProfileResponse> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a group profile is updated.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which a group profile is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the group profile that is updated.
         * </p>
         * 
         * @param groupName
         *        The name of the group profile that is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The identifier of the group profile that is updated.
         * </p>
         * 
         * @param id
         *        The identifier of the group profile that is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the group profile that is updated.
         * </p>
         * 
         * @param status
         *        The status of the group profile that is updated.
         * @see GroupProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the group profile that is updated.
         * </p>
         * 
         * @param status
         *        The status of the group profile that is updated.
         * @see GroupProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupProfileStatus
         */
        Builder status(GroupProfileStatus status);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String domainId;

        private String groupName;

        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupProfileResponse model) {
            super(model);
            domainId(model.domainId);
            groupName(model.groupName);
            id(model.id);
            status(model.status);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GroupProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateGroupProfileResponse build() {
            return new UpdateGroupProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
