/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.dax.model.DaxRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncreaseReplicationFactorRequest
extends DaxRequest
implements ToCopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(IncreaseReplicationFactorRequest.getter(IncreaseReplicationFactorRequest::clusterName)).setter(IncreaseReplicationFactorRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<Integer> NEW_REPLICATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NewReplicationFactor").getter(IncreaseReplicationFactorRequest.getter(IncreaseReplicationFactorRequest::newReplicationFactor)).setter(IncreaseReplicationFactorRequest.setter(Builder::newReplicationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicationFactor").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(IncreaseReplicationFactorRequest.getter(IncreaseReplicationFactorRequest::availabilityZones)).setter(IncreaseReplicationFactorRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NEW_REPLICATION_FACTOR_FIELD, AVAILABILITY_ZONES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncreaseReplicationFactorRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final Integer newReplicationFactor;
    private final List<String> availabilityZones;

    private IncreaseReplicationFactorRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Integer newReplicationFactor() {
        return this.newReplicationFactor;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newReplicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicationFactorRequest)) {
            return false;
        }
        IncreaseReplicationFactorRequest other = (IncreaseReplicationFactorRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.newReplicationFactor(), other.newReplicationFactor()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"IncreaseReplicationFactorRequest").add("ClusterName", (Object)this.clusterName()).add("NewReplicationFactor", (Object)this.newReplicationFactor()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "NewReplicationFactor": {
                return Optional.ofNullable(clazz.cast(this.newReplicationFactor()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("NewReplicationFactor", NEW_REPLICATION_FACTOR_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncreaseReplicationFactorRequest, T> g) {
        return obj -> g.apply((IncreaseReplicationFactorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DaxRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private Integer newReplicationFactor;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicationFactorRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.newReplicationFactor(model.newReplicationFactor);
            this.availabilityZones(model.availabilityZones);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Integer getNewReplicationFactor() {
            return this.newReplicationFactor;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseReplicationFactorRequest build() {
            return new IncreaseReplicationFactorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DaxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
        public Builder clusterName(String var1);

        public Builder newReplicationFactor(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

