/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoScalingMode {
    NO_SCALING("NO_SCALING"),
    EVENT_BASED_AUTO_SCALING("EVENT_BASED_AUTO_SCALING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoScalingMode> VALUE_MAP;
    private final String value;

    private AutoScalingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoScalingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoScalingMode> knownValues() {
        EnumSet<AutoScalingMode> knownValues = EnumSet.allOf(AutoScalingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoScalingMode.class, AutoScalingMode::toString);
    }
}

