/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.BudgetSummary;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;

public class ListBudgetsIterable
implements SdkIterable<ListBudgetsResponse> {
    private final DeadlineClient client;
    private final ListBudgetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBudgetsIterable(DeadlineClient client, ListBudgetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBudgetsResponseFetcher();
    }

    public Iterator<ListBudgetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BudgetSummary> budgets() {
        Function<ListBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgets() != null) {
                return response.budgets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBudgetsResponseFetcher
    implements SyncPageFetcher<ListBudgetsResponse> {
        private ListBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBudgetsResponse nextPage(ListBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListBudgetsIterable.this.client.listBudgets(ListBudgetsIterable.this.firstRequest);
            }
            return ListBudgetsIterable.this.client.listBudgets((ListBudgetsRequest)((Object)ListBudgetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

