/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FarmSummary;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;

public class ListFarmsIterable
implements SdkIterable<ListFarmsResponse> {
    private final DeadlineClient client;
    private final ListFarmsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFarmsIterable(DeadlineClient client, ListFarmsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFarmsResponseFetcher();
    }

    public Iterator<ListFarmsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FarmSummary> farms() {
        Function<ListFarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.farms() != null) {
                return response.farms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFarmsResponseFetcher
    implements SyncPageFetcher<ListFarmsResponse> {
        private ListFarmsResponseFetcher() {
        }

        public boolean hasNextPage(ListFarmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFarmsResponse nextPage(ListFarmsResponse previousPage) {
            if (previousPage == null) {
                return ListFarmsIterable.this.client.listFarms(ListFarmsIterable.this.firstRequest);
            }
            return ListFarmsIterable.this.client.listFarms((ListFarmsRequest)((Object)ListFarmsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

