/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FleetSummary;
import software.amazon.awssdk.services.deadline.model.ListFleetsRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetsResponse;

public class ListFleetsPublisher
implements SdkPublisher<ListFleetsResponse> {
    private final DeadlineAsyncClient client;
    private final ListFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetsPublisher(DeadlineAsyncClient client, ListFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetsPublisher(DeadlineAsyncClient client, ListFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetSummary> fleets() {
        Function<ListFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleets() != null) {
                return response.fleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFleetsResponseFetcher
    implements AsyncPageFetcher<ListFleetsResponse> {
        private ListFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetsResponse> nextPage(ListFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsPublisher.this.client.listFleets(ListFleetsPublisher.this.firstRequest);
            }
            return ListFleetsPublisher.this.client.listFleets((ListFleetsRequest)((Object)ListFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

