/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;

public class ListLicenseEndpointsPublisher
implements SdkPublisher<ListLicenseEndpointsResponse> {
    private final DeadlineAsyncClient client;
    private final ListLicenseEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLicenseEndpointsPublisher(DeadlineAsyncClient client, ListLicenseEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLicenseEndpointsPublisher(DeadlineAsyncClient client, ListLicenseEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLicenseEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLicenseEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LicenseEndpointSummary> licenseEndpoints() {
        Function<ListLicenseEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.licenseEndpoints() != null) {
                return response.licenseEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLicenseEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLicenseEndpointsResponseFetcher
    implements AsyncPageFetcher<ListLicenseEndpointsResponse> {
        private ListLicenseEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListLicenseEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLicenseEndpointsResponse> nextPage(ListLicenseEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListLicenseEndpointsPublisher.this.client.listLicenseEndpoints(ListLicenseEndpointsPublisher.this.firstRequest);
            }
            return ListLicenseEndpointsPublisher.this.client.listLicenseEndpoints((ListLicenseEndpointsRequest)((Object)ListLicenseEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

