/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.detective.model.DatasourcePackage;
import software.amazon.awssdk.services.detective.model.DatasourcePackageIngestHistoryCopier;
import software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState;
import software.amazon.awssdk.services.detective.model.TimestampForCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MembershipDatasources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MembershipDatasources> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(MembershipDatasources.getter(MembershipDatasources::accountId)).setter(MembershipDatasources.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(MembershipDatasources.getter(MembershipDatasources::graphArn)).setter(MembershipDatasources.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<Map<String, Map<String, TimestampForCollection>>> DATASOURCE_PACKAGE_INGEST_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DatasourcePackageIngestHistory").getter(MembershipDatasources.getter(MembershipDatasources::datasourcePackageIngestHistoryAsStrings)).setter(MembershipDatasources.setter(Builder::datasourcePackageIngestHistoryWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackageIngestHistory").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestampForCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, GRAPH_ARN_FIELD, DATASOURCE_PACKAGE_INGEST_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("GraphArn", GRAPH_ARN_FIELD);
            this.put("DatasourcePackageIngestHistory", DATASOURCE_PACKAGE_INGEST_HISTORY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String graphArn;
    private final Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory;

    private MembershipDatasources(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.graphArn = builder.graphArn;
        this.datasourcePackageIngestHistory = builder.datasourcePackageIngestHistory;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final Map<DatasourcePackage, Map<DatasourcePackageIngestState, TimestampForCollection>> datasourcePackageIngestHistory() {
        return DatasourcePackageIngestHistoryCopier.copyStringToEnum(this.datasourcePackageIngestHistory);
    }

    public final boolean hasDatasourcePackageIngestHistory() {
        return this.datasourcePackageIngestHistory != null && !(this.datasourcePackageIngestHistory instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistoryAsStrings() {
        return this.datasourcePackageIngestHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasourcePackageIngestHistory() ? this.datasourcePackageIngestHistoryAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipDatasources)) {
            return false;
        }
        MembershipDatasources other = (MembershipDatasources)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.graphArn(), other.graphArn()) && this.hasDatasourcePackageIngestHistory() == other.hasDatasourcePackageIngestHistory() && Objects.equals(this.datasourcePackageIngestHistoryAsStrings(), other.datasourcePackageIngestHistoryAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"MembershipDatasources").add("AccountId", (Object)this.accountId()).add("GraphArn", (Object)this.graphArn()).add("DatasourcePackageIngestHistory", this.hasDatasourcePackageIngestHistory() ? this.datasourcePackageIngestHistoryAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "DatasourcePackageIngestHistory": {
                return Optional.ofNullable(clazz.cast(this.datasourcePackageIngestHistoryAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MembershipDatasources, T> g) {
        return obj -> g.apply((MembershipDatasources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String graphArn;
        private Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipDatasources model) {
            this.accountId(model.accountId);
            this.graphArn(model.graphArn);
            this.datasourcePackageIngestHistoryWithStrings(model.datasourcePackageIngestHistory);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Map<String, Map<String, TimestampForCollection.Builder>> getDatasourcePackageIngestHistory() {
            Map<String, Map<String, TimestampForCollection.Builder>> result = DatasourcePackageIngestHistoryCopier.copyToBuilder(this.datasourcePackageIngestHistory);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDatasourcePackageIngestHistory(Map<String, ? extends Map<String, TimestampForCollection.BuilderImpl>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier.copyFromBuilder(datasourcePackageIngestHistory);
        }

        @Override
        public final Builder datasourcePackageIngestHistoryWithStrings(Map<String, ? extends Map<String, TimestampForCollection>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier.copy(datasourcePackageIngestHistory);
            return this;
        }

        @Override
        public final Builder datasourcePackageIngestHistory(Map<DatasourcePackage, ? extends Map<DatasourcePackageIngestState, TimestampForCollection>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier.copyEnumToString(datasourcePackageIngestHistory);
            return this;
        }

        public MembershipDatasources build() {
            return new MembershipDatasources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MembershipDatasources> {
        public Builder accountId(String var1);

        public Builder graphArn(String var1);

        public Builder datasourcePackageIngestHistoryWithStrings(Map<String, ? extends Map<String, TimestampForCollection>> var1);

        public Builder datasourcePackageIngestHistory(Map<DatasourcePackage, ? extends Map<DatasourcePackageIngestState, TimestampForCollection>> var1);
    }
}

