/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class DatasourcePackageIngestHistoryCopier {
    static Map<String, Map<String, TimestampForCollection>> copy(
            Map<String, ? extends Map<String, ? extends TimestampForCollection>> datasourcePackageIngestHistoryParam) {
        Map<String, Map<String, TimestampForCollection>> map;
        if (datasourcePackageIngestHistoryParam == null || datasourcePackageIngestHistoryParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, TimestampForCollection>> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestHistoryParam.size());
            datasourcePackageIngestHistoryParam.forEach((key, value) -> {
                Map<String, TimestampForCollection> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, TimestampForCollection> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, TimestampForCollection>> copyFromBuilder(
            Map<String, ? extends Map<String, ? extends TimestampForCollection.Builder>> datasourcePackageIngestHistoryParam) {
        Map<String, Map<String, TimestampForCollection>> map;
        if (datasourcePackageIngestHistoryParam == null || datasourcePackageIngestHistoryParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, TimestampForCollection>> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestHistoryParam.size());
            datasourcePackageIngestHistoryParam.forEach((key, value) -> {
                Map<String, TimestampForCollection> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, TimestampForCollection> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        TimestampForCollection member = value1 == null ? null : value1.build();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, TimestampForCollection.Builder>> copyToBuilder(
            Map<String, ? extends Map<String, ? extends TimestampForCollection>> datasourcePackageIngestHistoryParam) {
        Map<String, Map<String, TimestampForCollection.Builder>> map;
        if (datasourcePackageIngestHistoryParam == null || datasourcePackageIngestHistoryParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, TimestampForCollection.Builder>> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestHistoryParam.size());
            datasourcePackageIngestHistoryParam.forEach((key, value) -> {
                Map<String, TimestampForCollection.Builder> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, TimestampForCollection.Builder> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        TimestampForCollection.Builder member = value1 == null ? null : value1.toBuilder();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, TimestampForCollection>> copyEnumToString(
            Map<DatasourcePackage, ? extends Map<DatasourcePackageIngestState, ? extends TimestampForCollection>> datasourcePackageIngestHistoryParam) {
        Map<String, Map<String, TimestampForCollection>> map;
        if (datasourcePackageIngestHistoryParam == null || datasourcePackageIngestHistoryParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, TimestampForCollection>> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestHistoryParam.size());
            datasourcePackageIngestHistoryParam.forEach((key, value) -> {
                String result = key.toString();
                Map<String, TimestampForCollection> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, TimestampForCollection> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        String result1 = key1.toString();
                        modifiableMap1.put(result1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(result, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DatasourcePackage, Map<DatasourcePackageIngestState, TimestampForCollection>> copyStringToEnum(
            Map<String, ? extends Map<String, ? extends TimestampForCollection>> datasourcePackageIngestHistoryParam) {
        Map<DatasourcePackage, Map<DatasourcePackageIngestState, TimestampForCollection>> map;
        if (datasourcePackageIngestHistoryParam == null || datasourcePackageIngestHistoryParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DatasourcePackage, Map<DatasourcePackageIngestState, TimestampForCollection>> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestHistoryParam.size());
            datasourcePackageIngestHistoryParam.forEach((key, value) -> {
                DatasourcePackage result = DatasourcePackage.fromValue(key);
                Map<DatasourcePackageIngestState, TimestampForCollection> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<DatasourcePackageIngestState, TimestampForCollection> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        DatasourcePackageIngestState result1 = DatasourcePackageIngestState.fromValue(key1);
                        if (result1 != DatasourcePackageIngestState.UNKNOWN_TO_SDK_VERSION) {
                            modifiableMap1.put(result1, value1);
                        }
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                if (result != DatasourcePackage.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, map1);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
