/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the investigation related to a potential security event identified by Detective.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvestigationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<InvestigationDetail.Builder, InvestigationDetail> {
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvestigationId").getter(getter(InvestigationDetail::investigationId))
            .setter(setter(Builder::investigationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(InvestigationDetail::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InvestigationDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InvestigationDetail::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(InvestigationDetail::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(InvestigationDetail::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(InvestigationDetail::entityTypeAsString)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVESTIGATION_ID_FIELD,
            SEVERITY_FIELD, STATUS_FIELD, STATE_FIELD, CREATED_TIME_FIELD, ENTITY_ARN_FIELD, ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String investigationId;

    private final String severity;

    private final String status;

    private final String state;

    private final Instant createdTime;

    private final String entityArn;

    private final String entityType;

    private InvestigationDetail(BuilderImpl builder) {
        this.investigationId = builder.investigationId;
        this.severity = builder.severity;
        this.status = builder.status;
        this.state = builder.state;
        this.createdTime = builder.createdTime;
        this.entityArn = builder.entityArn;
        this.entityType = builder.entityType;
    }

    /**
     * <p>
     * The investigation ID of the investigation report.
     * </p>
     * 
     * @return The investigation ID of the investigation report.
     */
    public final String investigationId() {
        return investigationId;
    }

    /**
     * <p>
     * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return Severity based on the likelihood and impact of the indicators of compromise discovered in the
     *         investigation.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return Severity based on the likelihood and impact of the indicators of compromise discovered in the
     *         investigation.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * Status based on the completion status of the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status based on the completion status of the investigation.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status based on the completion status of the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status based on the completion status of the investigation.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The current state of the investigation. An archived investigation indicates you have completed reviewing the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the investigation. An archived investigation indicates you have completed reviewing
     *         the investigation.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The current state of the investigation. An archived investigation indicates you have completed reviewing the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the investigation. An archived investigation indicates you have completed reviewing
     *         the investigation.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted string.
     * For example, <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted
     *         string. For example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvestigationDetail)) {
            return false;
        }
        InvestigationDetail other = (InvestigationDetail) obj;
        return Objects.equals(investigationId(), other.investigationId())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvestigationDetail").add("InvestigationId", investigationId())
                .add("Severity", severityAsString()).add("Status", statusAsString()).add("State", stateAsString())
                .add("CreatedTime", createdTime()).add("EntityArn", entityArn()).add("EntityType", entityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvestigationId":
            return Optional.ofNullable(clazz.cast(investigationId()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvestigationId", INVESTIGATION_ID_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvestigationDetail, T> g) {
        return obj -> g.apply((InvestigationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvestigationDetail> {
        /**
         * <p>
         * The investigation ID of the investigation report.
         * </p>
         * 
         * @param investigationId
         *        The investigation ID of the investigation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationId(String investigationId);

        /**
         * <p>
         * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
         * </p>
         * 
         * @param severity
         *        Severity based on the likelihood and impact of the indicators of compromise discovered in the
         *        investigation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
         * </p>
         * 
         * @param severity
         *        Severity based on the likelihood and impact of the indicators of compromise discovered in the
         *        investigation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * Status based on the completion status of the investigation.
         * </p>
         * 
         * @param status
         *        Status based on the completion status of the investigation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status based on the completion status of the investigation.
         * </p>
         * 
         * @param status
         *        Status based on the completion status of the investigation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The current state of the investigation. An archived investigation indicates you have completed reviewing the
         * investigation.
         * </p>
         * 
         * @param state
         *        The current state of the investigation. An archived investigation indicates you have completed
         *        reviewing the investigation.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the investigation. An archived investigation indicates you have completed reviewing the
         * investigation.
         * </p>
         * 
         * @param state
         *        The current state of the investigation. An archived investigation indicates you have completed
         *        reviewing the investigation.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted
         * string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param createdTime
         *        The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted
         *        string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
         * </p>
         * 
         * @param entityArn
         *        The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
         * </p>
         * 
         * @param entityType
         *        Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
         * </p>
         * 
         * @param entityType
         *        Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);
    }

    static final class BuilderImpl implements Builder {
        private String investigationId;

        private String severity;

        private String status;

        private String state;

        private Instant createdTime;

        private String entityArn;

        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvestigationDetail model) {
            investigationId(model.investigationId);
            severity(model.severity);
            status(model.status);
            state(model.state);
            createdTime(model.createdTime);
            entityArn(model.entityArn);
            entityType(model.entityType);
        }

        public final String getInvestigationId() {
            return investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public InvestigationDetail build() {
            return new InvestigationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
