/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasourcePackagesResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListDatasourcePackagesResponse.Builder, ListDatasourcePackagesResponse> {
    private static final SdkField<Map<String, DatasourcePackageIngestDetail>> DATASOURCE_PACKAGES_FIELD = SdkField
            .<Map<String, DatasourcePackageIngestDetail>> builder(MarshallingType.MAP)
            .memberName("DatasourcePackages")
            .getter(getter(ListDatasourcePackagesResponse::datasourcePackagesAsStrings))
            .setter(setter(Builder::datasourcePackagesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackages").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DatasourcePackageIngestDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasourcePackageIngestDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasourcePackagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASOURCE_PACKAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, DatasourcePackageIngestDetail> datasourcePackages;

    private final String nextToken;

    private ListDatasourcePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.datasourcePackages = builder.datasourcePackages;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Details on the data source packages active in the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackages} method.
     * </p>
     * 
     * @return Details on the data source packages active in the behavior graph.
     */
    public final Map<DatasourcePackage, DatasourcePackageIngestDetail> datasourcePackages() {
        return DatasourcePackageIngestDetailsCopier.copyStringToEnum(datasourcePackages);
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasourcePackages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasourcePackages() {
        return datasourcePackages != null && !(datasourcePackages instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details on the data source packages active in the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackages} method.
     * </p>
     * 
     * @return Details on the data source packages active in the behavior graph.
     */
    public final Map<String, DatasourcePackageIngestDetail> datasourcePackagesAsStrings() {
        return datasourcePackages;
    }

    /**
     * <p>
     * For requests to get the next page of results, the pagination token that was returned with the previous set of
     * results. The initial request does not include a pagination token.
     * </p>
     * 
     * @return For requests to get the next page of results, the pagination token that was returned with the previous
     *         set of results. The initial request does not include a pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasourcePackages() ? datasourcePackagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasourcePackagesResponse)) {
            return false;
        }
        ListDatasourcePackagesResponse other = (ListDatasourcePackagesResponse) obj;
        return hasDatasourcePackages() == other.hasDatasourcePackages()
                && Objects.equals(datasourcePackagesAsStrings(), other.datasourcePackagesAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDatasourcePackagesResponse")
                .add("DatasourcePackages", hasDatasourcePackages() ? datasourcePackagesAsStrings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasourcePackages":
            return Optional.ofNullable(clazz.cast(datasourcePackagesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasourcePackages", DATASOURCE_PACKAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasourcePackagesResponse, T> g) {
        return obj -> g.apply((ListDatasourcePackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasourcePackagesResponse> {
        /**
         * <p>
         * Details on the data source packages active in the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        Details on the data source packages active in the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackagesWithStrings(Map<String, DatasourcePackageIngestDetail> datasourcePackages);

        /**
         * <p>
         * Details on the data source packages active in the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        Details on the data source packages active in the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackages(Map<DatasourcePackage, DatasourcePackageIngestDetail> datasourcePackages);

        /**
         * <p>
         * For requests to get the next page of results, the pagination token that was returned with the previous set of
         * results. The initial request does not include a pagination token.
         * </p>
         * 
         * @param nextToken
         *        For requests to get the next page of results, the pagination token that was returned with the previous
         *        set of results. The initial request does not include a pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private Map<String, DatasourcePackageIngestDetail> datasourcePackages = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasourcePackagesResponse model) {
            super(model);
            datasourcePackagesWithStrings(model.datasourcePackages);
            nextToken(model.nextToken);
        }

        public final Map<String, DatasourcePackageIngestDetail.Builder> getDatasourcePackages() {
            Map<String, DatasourcePackageIngestDetail.Builder> result = DatasourcePackageIngestDetailsCopier
                    .copyToBuilder(this.datasourcePackages);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDatasourcePackages(Map<String, DatasourcePackageIngestDetail.BuilderImpl> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copyFromBuilder(datasourcePackages);
        }

        @Override
        public final Builder datasourcePackagesWithStrings(Map<String, DatasourcePackageIngestDetail> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copy(datasourcePackages);
            return this;
        }

        @Override
        public final Builder datasourcePackages(Map<DatasourcePackage, DatasourcePackageIngestDetail> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copyEnumToString(datasourcePackages);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasourcePackagesResponse build() {
            return new ListDatasourcePackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
