/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents entity counters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Counters implements SdkPojo, Serializable, ToCopyableBuilder<Counters.Builder, Counters> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(Counters::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Integer> PASSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("passed").getter(getter(Counters::passed)).setter(setter(Builder::passed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passed").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(Counters::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> WARNED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("warned").getter(getter(Counters::warned)).setter(setter(Builder::warned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warned").build()).build();

    private static final SdkField<Integer> ERRORED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("errored").getter(getter(Counters::errored)).setter(setter(Builder::errored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errored").build()).build();

    private static final SdkField<Integer> STOPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("stopped").getter(getter(Counters::stopped)).setter(setter(Builder::stopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()).build();

    private static final SdkField<Integer> SKIPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("skipped").getter(getter(Counters::skipped)).setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, PASSED_FIELD,
            FAILED_FIELD, WARNED_FIELD, ERRORED_FIELD, STOPPED_FIELD, SKIPPED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer total;

    private final Integer passed;

    private final Integer failed;

    private final Integer warned;

    private final Integer errored;

    private final Integer stopped;

    private final Integer skipped;

    private Counters(BuilderImpl builder) {
        this.total = builder.total;
        this.passed = builder.passed;
        this.failed = builder.failed;
        this.warned = builder.warned;
        this.errored = builder.errored;
        this.stopped = builder.stopped;
        this.skipped = builder.skipped;
    }

    /**
     * <p>
     * The total number of entities.
     * </p>
     * 
     * @return The total number of entities.
     */
    public final Integer total() {
        return total;
    }

    /**
     * <p>
     * The number of passed entities.
     * </p>
     * 
     * @return The number of passed entities.
     */
    public final Integer passed() {
        return passed;
    }

    /**
     * <p>
     * The number of failed entities.
     * </p>
     * 
     * @return The number of failed entities.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of warned entities.
     * </p>
     * 
     * @return The number of warned entities.
     */
    public final Integer warned() {
        return warned;
    }

    /**
     * <p>
     * The number of errored entities.
     * </p>
     * 
     * @return The number of errored entities.
     */
    public final Integer errored() {
        return errored;
    }

    /**
     * <p>
     * The number of stopped entities.
     * </p>
     * 
     * @return The number of stopped entities.
     */
    public final Integer stopped() {
        return stopped;
    }

    /**
     * <p>
     * The number of skipped entities.
     * </p>
     * 
     * @return The number of skipped entities.
     */
    public final Integer skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(warned());
        hashCode = 31 * hashCode + Objects.hashCode(errored());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Counters)) {
            return false;
        }
        Counters other = (Counters) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(passed(), other.passed())
                && Objects.equals(failed(), other.failed()) && Objects.equals(warned(), other.warned())
                && Objects.equals(errored(), other.errored()) && Objects.equals(stopped(), other.stopped())
                && Objects.equals(skipped(), other.skipped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Counters").add("Total", total()).add("Passed", passed()).add("Failed", failed())
                .add("Warned", warned()).add("Errored", errored()).add("Stopped", stopped()).add("Skipped", skipped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "passed":
            return Optional.ofNullable(clazz.cast(passed()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "warned":
            return Optional.ofNullable(clazz.cast(warned()));
        case "errored":
            return Optional.ofNullable(clazz.cast(errored()));
        case "stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        case "skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("total", TOTAL_FIELD);
        map.put("passed", PASSED_FIELD);
        map.put("failed", FAILED_FIELD);
        map.put("warned", WARNED_FIELD);
        map.put("errored", ERRORED_FIELD);
        map.put("stopped", STOPPED_FIELD);
        map.put("skipped", SKIPPED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Counters, T> g) {
        return obj -> g.apply((Counters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Counters> {
        /**
         * <p>
         * The total number of entities.
         * </p>
         * 
         * @param total
         *        The total number of entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * The number of passed entities.
         * </p>
         * 
         * @param passed
         *        The number of passed entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * The number of failed entities.
         * </p>
         * 
         * @param failed
         *        The number of failed entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of warned entities.
         * </p>
         * 
         * @param warned
         *        The number of warned entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warned(Integer warned);

        /**
         * <p>
         * The number of errored entities.
         * </p>
         * 
         * @param errored
         *        The number of errored entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errored(Integer errored);

        /**
         * <p>
         * The number of stopped entities.
         * </p>
         * 
         * @param stopped
         *        The number of stopped entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Integer stopped);

        /**
         * <p>
         * The number of skipped entities.
         * </p>
         * 
         * @param skipped
         *        The number of skipped entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Integer skipped);
    }

    static final class BuilderImpl implements Builder {
        private Integer total;

        private Integer passed;

        private Integer failed;

        private Integer warned;

        private Integer errored;

        private Integer stopped;

        private Integer skipped;

        private BuilderImpl() {
        }

        private BuilderImpl(Counters model) {
            total(model.total);
            passed(model.passed);
            failed(model.failed);
            warned(model.warned);
            errored(model.errored);
            stopped(model.stopped);
            skipped(model.skipped);
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getPassed() {
            return passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getWarned() {
            return warned;
        }

        public final void setWarned(Integer warned) {
            this.warned = warned;
        }

        @Override
        public final Builder warned(Integer warned) {
            this.warned = warned;
            return this;
        }

        public final Integer getErrored() {
            return errored;
        }

        public final void setErrored(Integer errored) {
            this.errored = errored;
        }

        @Override
        public final Builder errored(Integer errored) {
            this.errored = errored;
            return this;
        }

        public final Integer getStopped() {
            return stopped;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Integer getSkipped() {
            return skipped;
        }

        public final void setSkipped(Integer skipped) {
            this.skipped = skipped;
        }

        @Override
        public final Builder skipped(Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        @Override
        public Counters build() {
            return new Counters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
