/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridSessionsRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<ListTestGridSessionsRequest.Builder, ListTestGridSessionsRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(ListTestGridSessionsRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListTestGridSessionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimeAfter").getter(getter(ListTestGridSessionsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimeBefore").getter(getter(ListTestGridSessionsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeBefore").build())
            .build();

    private static final SdkField<Instant> END_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTimeAfter").getter(getter(ListTestGridSessionsRequest::endTimeAfter))
            .setter(setter(Builder::endTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeAfter").build()).build();

    private static final SdkField<Instant> END_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTimeBefore").getter(getter(ListTestGridSessionsRequest::endTimeBefore))
            .setter(setter(Builder::endTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeBefore").build()).build();

    private static final SdkField<Integer> MAX_RESULT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResult").getter(getter(ListTestGridSessionsRequest::maxResult)).setter(setter(Builder::maxResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResult").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            STATUS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, END_TIME_AFTER_FIELD, END_TIME_BEFORE_FIELD,
            MAX_RESULT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectArn;

    private final String status;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant endTimeAfter;

    private final Instant endTimeBefore;

    private final Integer maxResult;

    private final String nextToken;

    private ListTestGridSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.status = builder.status;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.endTimeAfter = builder.endTimeAfter;
        this.endTimeBefore = builder.endTimeBefore;
        this.maxResult = builder.maxResult;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * ARN of a <a>TestGridProject</a>.
     * </p>
     * 
     * @return ARN of a <a>TestGridProject</a>.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * Return only sessions in this state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestGridSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Return only sessions in this state.
     * @see TestGridSessionStatus
     */
    public final TestGridSessionStatus status() {
        return TestGridSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * Return only sessions in this state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestGridSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Return only sessions in this state.
     * @see TestGridSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Return only sessions created after this time.
     * </p>
     * 
     * @return Return only sessions created after this time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Return only sessions created before this time.
     * </p>
     * 
     * @return Return only sessions created before this time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Return only sessions that ended after this time.
     * </p>
     * 
     * @return Return only sessions that ended after this time.
     */
    public final Instant endTimeAfter() {
        return endTimeAfter;
    }

    /**
     * <p>
     * Return only sessions that ended before this time.
     * </p>
     * 
     * @return Return only sessions that ended before this time.
     */
    public final Instant endTimeBefore() {
        return endTimeBefore;
    }

    /**
     * <p>
     * Return only this many results at a time.
     * </p>
     * 
     * @return Return only this many results at a time.
     */
    public final Integer maxResult() {
        return maxResult;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(maxResult());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionsRequest)) {
            return false;
        }
        ListTestGridSessionsRequest other = (ListTestGridSessionsRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(endTimeAfter(), other.endTimeAfter()) && Objects.equals(endTimeBefore(), other.endTimeBefore())
                && Objects.equals(maxResult(), other.maxResult()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestGridSessionsRequest").add("ProjectArn", projectArn()).add("Status", statusAsString())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("EndTimeAfter", endTimeAfter()).add("EndTimeBefore", endTimeBefore()).add("MaxResult", maxResult())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "creationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "endTimeAfter":
            return Optional.ofNullable(clazz.cast(endTimeAfter()));
        case "endTimeBefore":
            return Optional.ofNullable(clazz.cast(endTimeBefore()));
        case "maxResult":
            return Optional.ofNullable(clazz.cast(maxResult()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("creationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("endTimeAfter", END_TIME_AFTER_FIELD);
        map.put("endTimeBefore", END_TIME_BEFORE_FIELD);
        map.put("maxResult", MAX_RESULT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionsRequest, T> g) {
        return obj -> g.apply((ListTestGridSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTestGridSessionsRequest> {
        /**
         * <p>
         * ARN of a <a>TestGridProject</a>.
         * </p>
         * 
         * @param projectArn
         *        ARN of a <a>TestGridProject</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * Return only sessions in this state.
         * </p>
         * 
         * @param status
         *        Return only sessions in this state.
         * @see TestGridSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Return only sessions in this state.
         * </p>
         * 
         * @param status
         *        Return only sessions in this state.
         * @see TestGridSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionStatus
         */
        Builder status(TestGridSessionStatus status);

        /**
         * <p>
         * Return only sessions created after this time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Return only sessions created after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Return only sessions created before this time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Return only sessions created before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Return only sessions that ended after this time.
         * </p>
         * 
         * @param endTimeAfter
         *        Return only sessions that ended after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeAfter(Instant endTimeAfter);

        /**
         * <p>
         * Return only sessions that ended before this time.
         * </p>
         * 
         * @param endTimeBefore
         *        Return only sessions that ended before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeBefore(Instant endTimeBefore);

        /**
         * <p>
         * Return only this many results at a time.
         * </p>
         * 
         * @param maxResult
         *        Return only this many results at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResult(Integer maxResult);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String status;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant endTimeAfter;

        private Instant endTimeBefore;

        private Integer maxResult;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionsRequest model) {
            super(model);
            projectArn(model.projectArn);
            status(model.status);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            endTimeAfter(model.endTimeAfter);
            endTimeBefore(model.endTimeBefore);
            maxResult(model.maxResult);
            nextToken(model.nextToken);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestGridSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getEndTimeAfter() {
            return endTimeAfter;
        }

        public final void setEndTimeAfter(Instant endTimeAfter) {
            this.endTimeAfter = endTimeAfter;
        }

        @Override
        public final Builder endTimeAfter(Instant endTimeAfter) {
            this.endTimeAfter = endTimeAfter;
            return this;
        }

        public final Instant getEndTimeBefore() {
            return endTimeBefore;
        }

        public final void setEndTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
        }

        @Override
        public final Builder endTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public final Integer getMaxResult() {
            return maxResult;
        }

        public final void setMaxResult(Integer maxResult) {
            this.maxResult = maxResult;
        }

        @Override
        public final Builder maxResult(Integer maxResult) {
            this.maxResult = maxResult;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestGridSessionsRequest build() {
            return new ListTestGridSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
