/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TestType {
    BUILTIN_FUZZ("BUILTIN_FUZZ"),

    APPIUM_JAVA_JUNIT("APPIUM_JAVA_JUNIT"),

    APPIUM_JAVA_TESTNG("APPIUM_JAVA_TESTNG"),

    APPIUM_PYTHON("APPIUM_PYTHON"),

    APPIUM_NODE("APPIUM_NODE"),

    APPIUM_RUBY("APPIUM_RUBY"),

    APPIUM_WEB_JAVA_JUNIT("APPIUM_WEB_JAVA_JUNIT"),

    APPIUM_WEB_JAVA_TESTNG("APPIUM_WEB_JAVA_TESTNG"),

    APPIUM_WEB_PYTHON("APPIUM_WEB_PYTHON"),

    APPIUM_WEB_NODE("APPIUM_WEB_NODE"),

    APPIUM_WEB_RUBY("APPIUM_WEB_RUBY"),

    INSTRUMENTATION("INSTRUMENTATION"),

    XCTEST("XCTEST"),

    XCTEST_UI("XCTEST_UI"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestType> VALUE_MAP = EnumUtils.uniqueIndex(TestType.class, TestType::toString);

    private final String value;

    private TestType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TestType corresponding to the value
     */
    public static TestType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TestType}s
     */
    public static Set<TestType> knownValues() {
        Set<TestType> knownValues = EnumSet.allOf(TestType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
