/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryStage;
import software.amazon.awssdk.services.directory.model.DirectoryVpcSettings;
import software.amazon.awssdk.services.directory.model.RegionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionDescription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(RegionDescription.getter(RegionDescription::directoryId)).setter(RegionDescription.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(RegionDescription.getter(RegionDescription::regionName)).setter(RegionDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REGION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionType").getter(RegionDescription.getter(RegionDescription::regionTypeAsString)).setter(RegionDescription.setter(Builder::regionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RegionDescription.getter(RegionDescription::statusAsString)).setter(RegionDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcSettings").getter(RegionDescription.getter(RegionDescription::vpcSettings)).setter(RegionDescription.setter(Builder::vpcSettings)).constructor(DirectoryVpcSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()}).build();
    private static final SdkField<Integer> DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredNumberOfDomainControllers").getter(RegionDescription.getter(RegionDescription::desiredNumberOfDomainControllers)).setter(RegionDescription.setter(Builder::desiredNumberOfDomainControllers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredNumberOfDomainControllers").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(RegionDescription.getter(RegionDescription::launchTime)).setter(RegionDescription.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<Instant> STATUS_LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatusLastUpdatedDateTime").getter(RegionDescription.getter(RegionDescription::statusLastUpdatedDateTime)).setter(RegionDescription.setter(Builder::statusLastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusLastUpdatedDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(RegionDescription.getter(RegionDescription::lastUpdatedDateTime)).setter(RegionDescription.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, REGION_NAME_FIELD, REGION_TYPE_FIELD, STATUS_FIELD, VPC_SETTINGS_FIELD, DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD, LAUNCH_TIME_FIELD, STATUS_LAST_UPDATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("RegionName", REGION_NAME_FIELD);
            this.put("RegionType", REGION_TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("VpcSettings", VPC_SETTINGS_FIELD);
            this.put("DesiredNumberOfDomainControllers", DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD);
            this.put("LaunchTime", LAUNCH_TIME_FIELD);
            this.put("StatusLastUpdatedDateTime", STATUS_LAST_UPDATED_DATE_TIME_FIELD);
            this.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String regionName;
    private final String regionType;
    private final String status;
    private final DirectoryVpcSettings vpcSettings;
    private final Integer desiredNumberOfDomainControllers;
    private final Instant launchTime;
    private final Instant statusLastUpdatedDateTime;
    private final Instant lastUpdatedDateTime;

    private RegionDescription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.regionName = builder.regionName;
        this.regionType = builder.regionType;
        this.status = builder.status;
        this.vpcSettings = builder.vpcSettings;
        this.desiredNumberOfDomainControllers = builder.desiredNumberOfDomainControllers;
        this.launchTime = builder.launchTime;
        this.statusLastUpdatedDateTime = builder.statusLastUpdatedDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final RegionType regionType() {
        return RegionType.fromValue(this.regionType);
    }

    public final String regionTypeAsString() {
        return this.regionType;
    }

    public final DirectoryStage status() {
        return DirectoryStage.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DirectoryVpcSettings vpcSettings() {
        return this.vpcSettings;
    }

    public final Integer desiredNumberOfDomainControllers() {
        return this.desiredNumberOfDomainControllers;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final Instant statusLastUpdatedDateTime() {
        return this.statusLastUpdatedDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredNumberOfDomainControllers());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusLastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionDescription)) {
            return false;
        }
        RegionDescription other = (RegionDescription)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.regionTypeAsString(), other.regionTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.vpcSettings(), other.vpcSettings()) && Objects.equals(this.desiredNumberOfDomainControllers(), other.desiredNumberOfDomainControllers()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.statusLastUpdatedDateTime(), other.statusLastUpdatedDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"RegionDescription").add("DirectoryId", (Object)this.directoryId()).add("RegionName", (Object)this.regionName()).add("RegionType", (Object)this.regionTypeAsString()).add("Status", (Object)this.statusAsString()).add("VpcSettings", (Object)this.vpcSettings()).add("DesiredNumberOfDomainControllers", (Object)this.desiredNumberOfDomainControllers()).add("LaunchTime", (Object)this.launchTime()).add("StatusLastUpdatedDateTime", (Object)this.statusLastUpdatedDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "RegionType": {
                return Optional.ofNullable(clazz.cast(this.regionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VpcSettings": {
                return Optional.ofNullable(clazz.cast(this.vpcSettings()));
            }
            case "DesiredNumberOfDomainControllers": {
                return Optional.ofNullable(clazz.cast(this.desiredNumberOfDomainControllers()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "StatusLastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.statusLastUpdatedDateTime()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegionDescription, T> g) {
        return obj -> g.apply((RegionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String regionName;
        private String regionType;
        private String status;
        private DirectoryVpcSettings vpcSettings;
        private Integer desiredNumberOfDomainControllers;
        private Instant launchTime;
        private Instant statusLastUpdatedDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionDescription model) {
            this.directoryId(model.directoryId);
            this.regionName(model.regionName);
            this.regionType(model.regionType);
            this.status(model.status);
            this.vpcSettings(model.vpcSettings);
            this.desiredNumberOfDomainControllers(model.desiredNumberOfDomainControllers);
            this.launchTime(model.launchTime);
            this.statusLastUpdatedDateTime(model.statusLastUpdatedDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getRegionType() {
            return this.regionType;
        }

        public final void setRegionType(String regionType) {
            this.regionType = regionType;
        }

        @Override
        public final Builder regionType(String regionType) {
            this.regionType = regionType;
            return this;
        }

        @Override
        public final Builder regionType(RegionType regionType) {
            this.regionType(regionType == null ? null : regionType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DirectoryStage status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return this.vpcSettings != null ? this.vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final Integer getDesiredNumberOfDomainControllers() {
            return this.desiredNumberOfDomainControllers;
        }

        public final void setDesiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
        }

        @Override
        public final Builder desiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Instant getStatusLastUpdatedDateTime() {
            return this.statusLastUpdatedDateTime;
        }

        public final void setStatusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
        }

        @Override
        public final Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public RegionDescription build() {
            return new RegionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionDescription> {
        public Builder directoryId(String var1);

        public Builder regionName(String var1);

        public Builder regionType(String var1);

        public Builder regionType(RegionType var1);

        public Builder status(String var1);

        public Builder status(DirectoryStage var1);

        public Builder vpcSettings(DirectoryVpcSettings var1);

        default public Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return this.vpcSettings((DirectoryVpcSettings)((DirectoryVpcSettings.Builder)DirectoryVpcSettings.builder().applyMutation(vpcSettings)).build());
        }

        public Builder desiredNumberOfDomainControllers(Integer var1);

        public Builder launchTime(Instant var1);

        public Builder statusLastUpdatedDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

