/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectorySetupRequest extends DirectoryRequest implements
        ToCopyableBuilder<UpdateDirectorySetupRequest.Builder, UpdateDirectorySetupRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(UpdateDirectorySetupRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateType").getter(getter(UpdateDirectorySetupRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()).build();

    private static final SdkField<OSUpdateSettings> OS_UPDATE_SETTINGS_FIELD = SdkField
            .<OSUpdateSettings> builder(MarshallingType.SDK_POJO).memberName("OSUpdateSettings")
            .getter(getter(UpdateDirectorySetupRequest::osUpdateSettings)).setter(setter(Builder::osUpdateSettings))
            .constructor(OSUpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSUpdateSettings").build()).build();

    private static final SdkField<Boolean> CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateSnapshotBeforeUpdate")
            .getter(getter(UpdateDirectorySetupRequest::createSnapshotBeforeUpdate))
            .setter(setter(Builder::createSnapshotBeforeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSnapshotBeforeUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            UPDATE_TYPE_FIELD, OS_UPDATE_SETTINGS_FIELD, CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String updateType;

    private final OSUpdateSettings osUpdateSettings;

    private final Boolean createSnapshotBeforeUpdate;

    private UpdateDirectorySetupRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.updateType = builder.updateType;
        this.osUpdateSettings = builder.osUpdateSettings;
        this.createSnapshotBeforeUpdate = builder.createSnapshotBeforeUpdate;
    }

    /**
     * <p>
     * The identifier of the directory on which you want to perform the update.
     * </p>
     * 
     * @return The identifier of the directory on which you want to perform the update.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The type of update that needs to be performed on the directory. For example, OS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update that needs to be performed on the directory. For example, OS.
     * @see UpdateType
     */
    public final UpdateType updateType() {
        return UpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of update that needs to be performed on the directory. For example, OS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update that needs to be performed on the directory. For example, OS.
     * @see UpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    /**
     * <p>
     * The settings for the OS update that needs to be performed on the directory.
     * </p>
     * 
     * @return The settings for the OS update that needs to be performed on the directory.
     */
    public final OSUpdateSettings osUpdateSettings() {
        return osUpdateSettings;
    }

    /**
     * <p>
     * The boolean that specifies if a snapshot for the directory needs to be taken before updating the directory.
     * </p>
     * 
     * @return The boolean that specifies if a snapshot for the directory needs to be taken before updating the
     *         directory.
     */
    public final Boolean createSnapshotBeforeUpdate() {
        return createSnapshotBeforeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(createSnapshotBeforeUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectorySetupRequest)) {
            return false;
        }
        UpdateDirectorySetupRequest other = (UpdateDirectorySetupRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString())
                && Objects.equals(osUpdateSettings(), other.osUpdateSettings())
                && Objects.equals(createSnapshotBeforeUpdate(), other.createSnapshotBeforeUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectorySetupRequest").add("DirectoryId", directoryId())
                .add("UpdateType", updateTypeAsString()).add("OSUpdateSettings", osUpdateSettings())
                .add("CreateSnapshotBeforeUpdate", createSnapshotBeforeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UpdateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        case "OSUpdateSettings":
            return Optional.ofNullable(clazz.cast(osUpdateSettings()));
        case "CreateSnapshotBeforeUpdate":
            return Optional.ofNullable(clazz.cast(createSnapshotBeforeUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UpdateType", UPDATE_TYPE_FIELD);
        map.put("OSUpdateSettings", OS_UPDATE_SETTINGS_FIELD);
        map.put("CreateSnapshotBeforeUpdate", CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectorySetupRequest, T> g) {
        return obj -> g.apply((UpdateDirectorySetupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDirectorySetupRequest> {
        /**
         * <p>
         * The identifier of the directory on which you want to perform the update.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory on which you want to perform the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The type of update that needs to be performed on the directory. For example, OS.
         * </p>
         * 
         * @param updateType
         *        The type of update that needs to be performed on the directory. For example, OS.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of update that needs to be performed on the directory. For example, OS.
         * </p>
         * 
         * @param updateType
         *        The type of update that needs to be performed on the directory. For example, OS.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(UpdateType updateType);

        /**
         * <p>
         * The settings for the OS update that needs to be performed on the directory.
         * </p>
         * 
         * @param osUpdateSettings
         *        The settings for the OS update that needs to be performed on the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osUpdateSettings(OSUpdateSettings osUpdateSettings);

        /**
         * <p>
         * The settings for the OS update that needs to be performed on the directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link OSUpdateSettings.Builder} avoiding the
         * need to create one manually via {@link OSUpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OSUpdateSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #osUpdateSettings(OSUpdateSettings)}.
         * 
         * @param osUpdateSettings
         *        a consumer that will call methods on {@link OSUpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #osUpdateSettings(OSUpdateSettings)
         */
        default Builder osUpdateSettings(Consumer<OSUpdateSettings.Builder> osUpdateSettings) {
            return osUpdateSettings(OSUpdateSettings.builder().applyMutation(osUpdateSettings).build());
        }

        /**
         * <p>
         * The boolean that specifies if a snapshot for the directory needs to be taken before updating the directory.
         * </p>
         * 
         * @param createSnapshotBeforeUpdate
         *        The boolean that specifies if a snapshot for the directory needs to be taken before updating the
         *        directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String updateType;

        private OSUpdateSettings osUpdateSettings;

        private Boolean createSnapshotBeforeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectorySetupRequest model) {
            super(model);
            directoryId(model.directoryId);
            updateType(model.updateType);
            osUpdateSettings(model.osUpdateSettings);
            createSnapshotBeforeUpdate(model.createSnapshotBeforeUpdate);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final OSUpdateSettings.Builder getOsUpdateSettings() {
            return osUpdateSettings != null ? osUpdateSettings.toBuilder() : null;
        }

        public final void setOsUpdateSettings(OSUpdateSettings.BuilderImpl osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings != null ? osUpdateSettings.build() : null;
        }

        @Override
        public final Builder osUpdateSettings(OSUpdateSettings osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings;
            return this;
        }

        public final Boolean getCreateSnapshotBeforeUpdate() {
            return createSnapshotBeforeUpdate;
        }

        public final void setCreateSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
        }

        @Override
        public final Builder createSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectorySetupRequest build() {
            return new UpdateDirectorySetupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
