/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DirectoryEdition {
    ENTERPRISE("Enterprise"),
    STANDARD("Standard"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DirectoryEdition> VALUE_MAP;
    private final String value;

    private DirectoryEdition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryEdition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryEdition> knownValues() {
        EnumSet<DirectoryEdition> knownValues = EnumSet.allOf(DirectoryEdition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DirectoryEdition.class, DirectoryEdition::toString);
    }
}

