/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogSubscription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(LogSubscription.getter(LogSubscription::directoryId)).setter(LogSubscription.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(LogSubscription.getter(LogSubscription::logGroupName)).setter(LogSubscription.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<Instant> SUBSCRIPTION_CREATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubscriptionCreatedDateTime").getter(LogSubscription.getter(LogSubscription::subscriptionCreatedDateTime)).setter(LogSubscription.setter(Builder::subscriptionCreatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, LOG_GROUP_NAME_FIELD, SUBSCRIPTION_CREATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogSubscription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String logGroupName;
    private final Instant subscriptionCreatedDateTime;

    private LogSubscription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.logGroupName = builder.logGroupName;
        this.subscriptionCreatedDateTime = builder.subscriptionCreatedDateTime;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Instant subscriptionCreatedDateTime() {
        return this.subscriptionCreatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionCreatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSubscription)) {
            return false;
        }
        LogSubscription other = (LogSubscription)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.subscriptionCreatedDateTime(), other.subscriptionCreatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"LogSubscription").add("DirectoryId", (Object)this.directoryId()).add("LogGroupName", (Object)this.logGroupName()).add("SubscriptionCreatedDateTime", (Object)this.subscriptionCreatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "SubscriptionCreatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.subscriptionCreatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("LogGroupName", LOG_GROUP_NAME_FIELD);
        map.put("SubscriptionCreatedDateTime", SUBSCRIPTION_CREATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogSubscription, T> g) {
        return obj -> g.apply((LogSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String logGroupName;
        private Instant subscriptionCreatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSubscription model) {
            this.directoryId(model.directoryId);
            this.logGroupName(model.logGroupName);
            this.subscriptionCreatedDateTime(model.subscriptionCreatedDateTime);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getSubscriptionCreatedDateTime() {
            return this.subscriptionCreatedDateTime;
        }

        public final void setSubscriptionCreatedDateTime(Instant subscriptionCreatedDateTime) {
            this.subscriptionCreatedDateTime = subscriptionCreatedDateTime;
        }

        @Override
        public final Builder subscriptionCreatedDateTime(Instant subscriptionCreatedDateTime) {
            this.subscriptionCreatedDateTime = subscriptionCreatedDateTime;
            return this;
        }

        public LogSubscription build() {
            return new LogSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogSubscription> {
        public Builder directoryId(String var1);

        public Builder logGroupName(String var1);

        public Builder subscriptionCreatedDateTime(Instant var1);
    }
}

