/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.SharedDirectory;

public class DescribeSharedDirectoriesPublisher
implements SdkPublisher<DescribeSharedDirectoriesResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeSharedDirectoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSharedDirectoriesPublisher(DirectoryAsyncClient client, DescribeSharedDirectoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSharedDirectoriesPublisher(DirectoryAsyncClient client, DescribeSharedDirectoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSharedDirectoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSharedDirectoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SharedDirectory> sharedDirectories() {
        Function<DescribeSharedDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sharedDirectories() != null) {
                return response.sharedDirectories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSharedDirectoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSharedDirectoriesResponseFetcher
    implements AsyncPageFetcher<DescribeSharedDirectoriesResponse> {
        private DescribeSharedDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSharedDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSharedDirectoriesResponse> nextPage(DescribeSharedDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSharedDirectoriesPublisher.this.client.describeSharedDirectories(DescribeSharedDirectoriesPublisher.this.firstRequest);
            }
            return DescribeSharedDirectoriesPublisher.this.client.describeSharedDirectories((DescribeSharedDirectoriesRequest)((Object)DescribeSharedDirectoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

