/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of filters by which to return Source Servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSourceServersRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeSourceServersRequestFilters.Builder, DescribeSourceServersRequestFilters> {
    private static final SdkField<String> HARDWARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hardwareId").getter(getter(DescribeSourceServersRequestFilters::hardwareId))
            .setter(setter(Builder::hardwareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardwareId").build()).build();

    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceServerIDs")
            .getter(getter(DescribeSourceServersRequestFilters::sourceServerIDs))
            .setter(setter(Builder::sourceServerIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STAGING_ACCOUNT_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stagingAccountIDs")
            .getter(getter(DescribeSourceServersRequestFilters::stagingAccountIDs))
            .setter(setter(Builder::stagingAccountIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAccountIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HARDWARE_ID_FIELD,
            SOURCE_SERVER_I_DS_FIELD, STAGING_ACCOUNT_I_DS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hardwareId;

    private final List<String> sourceServerIDs;

    private final List<String> stagingAccountIDs;

    private DescribeSourceServersRequestFilters(BuilderImpl builder) {
        this.hardwareId = builder.hardwareId;
        this.sourceServerIDs = builder.sourceServerIDs;
        this.stagingAccountIDs = builder.stagingAccountIDs;
    }

    /**
     * <p>
     * An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac
     * address.
     * </p>
     * 
     * @return An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid
     *         or a mac address.
     */
    public final String hardwareId() {
        return hardwareId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceServerIDs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceServerIDs() {
        return sourceServerIDs != null && !(sourceServerIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceServerIDs} method.
     * </p>
     * 
     * @return An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
     */
    public final List<String> sourceServerIDs() {
        return sourceServerIDs;
    }

    /**
     * For responses, this returns true if the service returned a value for the StagingAccountIDs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStagingAccountIDs() {
        return stagingAccountIDs != null && !(stagingAccountIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of staging account IDs that extended source servers belong to. An empty array means all source servers
     * will be shown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStagingAccountIDs} method.
     * </p>
     * 
     * @return An array of staging account IDs that extended source servers belong to. An empty array means all source
     *         servers will be shown.
     */
    public final List<String> stagingAccountIDs() {
        return stagingAccountIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hardwareId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServerIDs() ? sourceServerIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStagingAccountIDs() ? stagingAccountIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceServersRequestFilters)) {
            return false;
        }
        DescribeSourceServersRequestFilters other = (DescribeSourceServersRequestFilters) obj;
        return Objects.equals(hardwareId(), other.hardwareId()) && hasSourceServerIDs() == other.hasSourceServerIDs()
                && Objects.equals(sourceServerIDs(), other.sourceServerIDs())
                && hasStagingAccountIDs() == other.hasStagingAccountIDs()
                && Objects.equals(stagingAccountIDs(), other.stagingAccountIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSourceServersRequestFilters").add("HardwareId", hardwareId())
                .add("SourceServerIDs", hasSourceServerIDs() ? sourceServerIDs() : null)
                .add("StagingAccountIDs", hasStagingAccountIDs() ? stagingAccountIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hardwareId":
            return Optional.ofNullable(clazz.cast(hardwareId()));
        case "sourceServerIDs":
            return Optional.ofNullable(clazz.cast(sourceServerIDs()));
        case "stagingAccountIDs":
            return Optional.ofNullable(clazz.cast(stagingAccountIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hardwareId", HARDWARE_ID_FIELD);
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        map.put("stagingAccountIDs", STAGING_ACCOUNT_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceServersRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceServersRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
        /**
         * <p>
         * An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a
         * mac address.
         * </p>
         * 
         * @param hardwareId
         *        An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware
         *        uuid or a mac address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardwareId(String hardwareId);

        /**
         * <p>
         * An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
         * </p>
         * 
         * @param sourceServerIDs
         *        An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(Collection<String> sourceServerIDs);

        /**
         * <p>
         * An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
         * </p>
         * 
         * @param sourceServerIDs
         *        An array of Source Servers IDs that should be returned. An empty array means all Source Servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(String... sourceServerIDs);

        /**
         * <p>
         * An array of staging account IDs that extended source servers belong to. An empty array means all source
         * servers will be shown.
         * </p>
         * 
         * @param stagingAccountIDs
         *        An array of staging account IDs that extended source servers belong to. An empty array means all
         *        source servers will be shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAccountIDs(Collection<String> stagingAccountIDs);

        /**
         * <p>
         * An array of staging account IDs that extended source servers belong to. An empty array means all source
         * servers will be shown.
         * </p>
         * 
         * @param stagingAccountIDs
         *        An array of staging account IDs that extended source servers belong to. An empty array means all
         *        source servers will be shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAccountIDs(String... stagingAccountIDs);
    }

    static final class BuilderImpl implements Builder {
        private String hardwareId;

        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private List<String> stagingAccountIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceServersRequestFilters model) {
            hardwareId(model.hardwareId);
            sourceServerIDs(model.sourceServerIDs);
            stagingAccountIDs(model.stagingAccountIDs);
        }

        public final String getHardwareId() {
            return hardwareId;
        }

        public final void setHardwareId(String hardwareId) {
            this.hardwareId = hardwareId;
        }

        @Override
        public final Builder hardwareId(String hardwareId) {
            this.hardwareId = hardwareId;
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String... sourceServerIDs) {
            sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public final Collection<String> getStagingAccountIDs() {
            if (stagingAccountIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return stagingAccountIDs;
        }

        public final void setStagingAccountIDs(Collection<String> stagingAccountIDs) {
            this.stagingAccountIDs = AccountIDsCopier.copy(stagingAccountIDs);
        }

        @Override
        public final Builder stagingAccountIDs(Collection<String> stagingAccountIDs) {
            this.stagingAccountIDs = AccountIDsCopier.copy(stagingAccountIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagingAccountIDs(String... stagingAccountIDs) {
            stagingAccountIDs(Arrays.asList(stagingAccountIDs));
            return this;
        }

        @Override
        public DescribeSourceServersRequestFilters build() {
            return new DescribeSourceServersRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
