/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchAction implements SdkPojo, Serializable, ToCopyableBuilder<LaunchAction.Builder, LaunchAction> {
    private static final SdkField<String> ACTION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionCode").getter(getter(LaunchAction::actionCode)).setter(setter(Builder::actionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionCode").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(LaunchAction::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> ACTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionVersion").getter(getter(LaunchAction::actionVersion)).setter(setter(Builder::actionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionVersion").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(LaunchAction::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(LaunchAction::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(LaunchAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LaunchAction::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("optional").getter(getter(LaunchAction::optional)).setter(setter(Builder::optional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()).build();

    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("order")
            .getter(getter(LaunchAction::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final SdkField<Map<String, LaunchActionParameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, LaunchActionParameter>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(LaunchAction::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LaunchActionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchActionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LaunchAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CODE_FIELD,
            ACTION_ID_FIELD, ACTION_VERSION_FIELD, ACTIVE_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, NAME_FIELD, OPTIONAL_FIELD,
            ORDER_FIELD, PARAMETERS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionCode;

    private final String actionId;

    private final String actionVersion;

    private final Boolean active;

    private final String category;

    private final String description;

    private final String name;

    private final Boolean optional;

    private final Integer order;

    private final Map<String, LaunchActionParameter> parameters;

    private final String type;

    private LaunchAction(BuilderImpl builder) {
        this.actionCode = builder.actionCode;
        this.actionId = builder.actionId;
        this.actionVersion = builder.actionVersion;
        this.active = builder.active;
        this.category = builder.category;
        this.description = builder.description;
        this.name = builder.name;
        this.optional = builder.optional;
        this.order = builder.order;
        this.parameters = builder.parameters;
        this.type = builder.type;
    }

    /**
     * <p>
     * Launch action code.
     * </p>
     * 
     * @return Launch action code.
     */
    public final String actionCode() {
        return actionCode;
    }

    /**
     * Returns the value of the ActionId property for this object.
     * 
     * @return The value of the ActionId property for this object.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * Returns the value of the ActionVersion property for this object.
     * 
     * @return The value of the ActionVersion property for this object.
     */
    public final String actionVersion() {
        return actionVersion;
    }

    /**
     * <p>
     * Whether the launch action is active.
     * </p>
     * 
     * @return Whether the launch action is active.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * Returns the value of the Category property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link LaunchActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The value of the Category property for this object.
     * @see LaunchActionCategory
     */
    public final LaunchActionCategory category() {
        return LaunchActionCategory.fromValue(category);
    }

    /**
     * Returns the value of the Category property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link LaunchActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The value of the Category property for this object.
     * @see LaunchActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether the launch will not be marked as failed if this action fails.
     * </p>
     * 
     * @return Whether the launch will not be marked as failed if this action fails.
     */
    public final Boolean optional() {
        return optional;
    }

    /**
     * Returns the value of the Order property for this object.
     * 
     * @return The value of the Order property for this object.
     */
    public final Integer order() {
        return order;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Parameters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The value of the Parameters property for this object.
     */
    public final Map<String, LaunchActionParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Launch action type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LaunchActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Launch action type.
     * @see LaunchActionType
     */
    public final LaunchActionType type() {
        return LaunchActionType.fromValue(type);
    }

    /**
     * <p>
     * Launch action type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LaunchActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Launch action type.
     * @see LaunchActionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionCode());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(optional());
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchAction)) {
            return false;
        }
        LaunchAction other = (LaunchAction) obj;
        return Objects.equals(actionCode(), other.actionCode()) && Objects.equals(actionId(), other.actionId())
                && Objects.equals(actionVersion(), other.actionVersion()) && Objects.equals(active(), other.active())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(optional(), other.optional()) && Objects.equals(order(), other.order())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchAction").add("ActionCode", actionCode()).add("ActionId", actionId())
                .add("ActionVersion", actionVersion()).add("Active", active()).add("Category", categoryAsString())
                .add("Description", description()).add("Name", name()).add("Optional", optional()).add("Order", order())
                .add("Parameters", hasParameters() ? parameters() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionCode":
            return Optional.ofNullable(clazz.cast(actionCode()));
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "actionVersion":
            return Optional.ofNullable(clazz.cast(actionVersion()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "optional":
            return Optional.ofNullable(clazz.cast(optional()));
        case "order":
            return Optional.ofNullable(clazz.cast(order()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionCode", ACTION_CODE_FIELD);
        map.put("actionId", ACTION_ID_FIELD);
        map.put("actionVersion", ACTION_VERSION_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("optional", OPTIONAL_FIELD);
        map.put("order", ORDER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchAction, T> g) {
        return obj -> g.apply((LaunchAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchAction> {
        /**
         * <p>
         * Launch action code.
         * </p>
         * 
         * @param actionCode
         *        Launch action code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionCode(String actionCode);

        /**
         * Sets the value of the ActionId property for this object.
         *
         * @param actionId
         *        The new value for the ActionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * Sets the value of the ActionVersion property for this object.
         *
         * @param actionVersion
         *        The new value for the ActionVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionVersion(String actionVersion);

        /**
         * <p>
         * Whether the launch action is active.
         * </p>
         * 
         * @param active
         *        Whether the launch action is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * Sets the value of the Category property for this object.
         *
         * @param category
         *        The new value for the Category property for this object.
         * @see LaunchActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionCategory
         */
        Builder category(String category);

        /**
         * Sets the value of the Category property for this object.
         *
         * @param category
         *        The new value for the Category property for this object.
         * @see LaunchActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionCategory
         */
        Builder category(LaunchActionCategory category);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether the launch will not be marked as failed if this action fails.
         * </p>
         * 
         * @param optional
         *        Whether the launch will not be marked as failed if this action fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optional(Boolean optional);

        /**
         * Sets the value of the Order property for this object.
         *
         * @param order
         *        The new value for the Order property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * Sets the value of the Parameters property for this object.
         *
         * @param parameters
         *        The new value for the Parameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, LaunchActionParameter> parameters);

        /**
         * <p>
         * Launch action type.
         * </p>
         * 
         * @param type
         *        Launch action type.
         * @see LaunchActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionType
         */
        Builder type(String type);

        /**
         * <p>
         * Launch action type.
         * </p>
         * 
         * @param type
         *        Launch action type.
         * @see LaunchActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionType
         */
        Builder type(LaunchActionType type);
    }

    static final class BuilderImpl implements Builder {
        private String actionCode;

        private String actionId;

        private String actionVersion;

        private Boolean active;

        private String category;

        private String description;

        private String name;

        private Boolean optional;

        private Integer order;

        private Map<String, LaunchActionParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchAction model) {
            actionCode(model.actionCode);
            actionId(model.actionId);
            actionVersion(model.actionVersion);
            active(model.active);
            category(model.category);
            description(model.description);
            name(model.name);
            optional(model.optional);
            order(model.order);
            parameters(model.parameters);
            type(model.type);
        }

        public final String getActionCode() {
            return actionCode;
        }

        public final void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }

        @Override
        public final Builder actionCode(String actionCode) {
            this.actionCode = actionCode;
            return this;
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getActionVersion() {
            return actionVersion;
        }

        public final void setActionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
        }

        @Override
        public final Builder actionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(LaunchActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getOptional() {
            return optional;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Integer getOrder() {
            return order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final Map<String, LaunchActionParameter.Builder> getParameters() {
            Map<String, LaunchActionParameter.Builder> result = LaunchActionParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, LaunchActionParameter.BuilderImpl> parameters) {
            this.parameters = LaunchActionParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, LaunchActionParameter> parameters) {
            this.parameters = LaunchActionParametersCopier.copy(parameters);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LaunchActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public LaunchAction build() {
            return new LaunchAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
