/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of the Recovery Instance machine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceProperties.Builder, RecoveryInstanceProperties> {
    private static final SdkField<List<CPU>> CPUS_FIELD = SdkField
            .<List<CPU>> builder(MarshallingType.LIST)
            .memberName("cpus")
            .getter(getter(RecoveryInstanceProperties::cpus))
            .setter(setter(Builder::cpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CPU> builder(MarshallingType.SDK_POJO)
                                            .constructor(CPU::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RecoveryInstanceDisk>> DISKS_FIELD = SdkField
            .<List<RecoveryInstanceDisk>> builder(MarshallingType.LIST)
            .memberName("disks")
            .getter(getter(RecoveryInstanceProperties::disks))
            .setter(setter(Builder::disks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecoveryInstanceDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecoveryInstanceDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IdentificationHints> IDENTIFICATION_HINTS_FIELD = SdkField
            .<IdentificationHints> builder(MarshallingType.SDK_POJO).memberName("identificationHints")
            .getter(getter(RecoveryInstanceProperties::identificationHints)).setter(setter(Builder::identificationHints))
            .constructor(IdentificationHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identificationHints").build())
            .build();

    private static final SdkField<String> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedDateTime").getter(getter(RecoveryInstanceProperties::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("networkInterfaces")
            .getter(getter(RecoveryInstanceProperties::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OS> OS_FIELD = SdkField.<OS> builder(MarshallingType.SDK_POJO).memberName("os")
            .getter(getter(RecoveryInstanceProperties::os)).setter(setter(Builder::os)).constructor(OS::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("os").build()).build();

    private static final SdkField<Long> RAM_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ramBytes")
            .getter(getter(RecoveryInstanceProperties::ramBytes)).setter(setter(Builder::ramBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPUS_FIELD, DISKS_FIELD,
            IDENTIFICATION_HINTS_FIELD, LAST_UPDATED_DATE_TIME_FIELD, NETWORK_INTERFACES_FIELD, OS_FIELD, RAM_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CPU> cpus;

    private final List<RecoveryInstanceDisk> disks;

    private final IdentificationHints identificationHints;

    private final String lastUpdatedDateTime;

    private final List<NetworkInterface> networkInterfaces;

    private final OS os;

    private final Long ramBytes;

    private RecoveryInstanceProperties(BuilderImpl builder) {
        this.cpus = builder.cpus;
        this.disks = builder.disks;
        this.identificationHints = builder.identificationHints;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.networkInterfaces = builder.networkInterfaces;
        this.os = builder.os;
        this.ramBytes = builder.ramBytes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cpus property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCpus() {
        return cpus != null && !(cpus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of CPUs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpus} method.
     * </p>
     * 
     * @return An array of CPUs.
     */
    public final List<CPU> cpus() {
        return cpus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Disks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasDisks() {
        return disks != null && !(disks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of disks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisks} method.
     * </p>
     * 
     * @return An array of disks.
     */
    public final List<RecoveryInstanceDisk> disks() {
        return disks;
    }

    /**
     * <p>
     * Hints used to uniquely identify a machine.
     * </p>
     * 
     * @return Hints used to uniquely identify a machine.
     */
    public final IdentificationHints identificationHints() {
        return identificationHints;
    }

    /**
     * <p>
     * The date and time the Recovery Instance properties were last updated on.
     * </p>
     * 
     * @return The date and time the Recovery Instance properties were last updated on.
     */
    public final String lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return An array of network interfaces.
     */
    public final List<NetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * Operating system.
     * </p>
     * 
     * @return Operating system.
     */
    public final OS os() {
        return os;
    }

    /**
     * <p>
     * The amount of RAM in bytes.
     * </p>
     * 
     * @return The amount of RAM in bytes.
     */
    public final Long ramBytes() {
        return ramBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCpus() ? cpus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisks() ? disks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identificationHints());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(ramBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceProperties)) {
            return false;
        }
        RecoveryInstanceProperties other = (RecoveryInstanceProperties) obj;
        return hasCpus() == other.hasCpus() && Objects.equals(cpus(), other.cpus()) && hasDisks() == other.hasDisks()
                && Objects.equals(disks(), other.disks()) && Objects.equals(identificationHints(), other.identificationHints())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces()) && Objects.equals(os(), other.os())
                && Objects.equals(ramBytes(), other.ramBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceProperties").add("Cpus", hasCpus() ? cpus() : null)
                .add("Disks", hasDisks() ? disks() : null).add("IdentificationHints", identificationHints())
                .add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).add("Os", os())
                .add("RamBytes", ramBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpus":
            return Optional.ofNullable(clazz.cast(cpus()));
        case "disks":
            return Optional.ofNullable(clazz.cast(disks()));
        case "identificationHints":
            return Optional.ofNullable(clazz.cast(identificationHints()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "networkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "os":
            return Optional.ofNullable(clazz.cast(os()));
        case "ramBytes":
            return Optional.ofNullable(clazz.cast(ramBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cpus", CPUS_FIELD);
        map.put("disks", DISKS_FIELD);
        map.put("identificationHints", IDENTIFICATION_HINTS_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("networkInterfaces", NETWORK_INTERFACES_FIELD);
        map.put("os", OS_FIELD);
        map.put("ramBytes", RAM_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceProperties, T> g) {
        return obj -> g.apply((RecoveryInstanceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceProperties> {
        /**
         * <p>
         * An array of CPUs.
         * </p>
         * 
         * @param cpus
         *        An array of CPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpus(Collection<CPU> cpus);

        /**
         * <p>
         * An array of CPUs.
         * </p>
         * 
         * @param cpus
         *        An array of CPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpus(CPU... cpus);

        /**
         * <p>
         * An array of CPUs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.CPU.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.drs.model.CPU#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.drs.model.CPU.Builder#build()} is
         * called immediately and its result is passed to {@link #cpus(List<CPU>)}.
         * 
         * @param cpus
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.drs.model.CPU.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpus(java.util.Collection<CPU>)
         */
        Builder cpus(Consumer<CPU.Builder>... cpus);

        /**
         * <p>
         * An array of disks.
         * </p>
         * 
         * @param disks
         *        An array of disks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<RecoveryInstanceDisk> disks);

        /**
         * <p>
         * An array of disks.
         * </p>
         * 
         * @param disks
         *        An array of disks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(RecoveryInstanceDisk... disks);

        /**
         * <p>
         * An array of disks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.RecoveryInstanceDisk.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.drs.model.RecoveryInstanceDisk#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.RecoveryInstanceDisk.Builder#build()} is called immediately
         * and its result is passed to {@link #disks(List<RecoveryInstanceDisk>)}.
         * 
         * @param disks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.RecoveryInstanceDisk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disks(java.util.Collection<RecoveryInstanceDisk>)
         */
        Builder disks(Consumer<RecoveryInstanceDisk.Builder>... disks);

        /**
         * <p>
         * Hints used to uniquely identify a machine.
         * </p>
         * 
         * @param identificationHints
         *        Hints used to uniquely identify a machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identificationHints(IdentificationHints identificationHints);

        /**
         * <p>
         * Hints used to uniquely identify a machine.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentificationHints.Builder} avoiding the
         * need to create one manually via {@link IdentificationHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentificationHints.Builder#build()} is called immediately and
         * its result is passed to {@link #identificationHints(IdentificationHints)}.
         * 
         * @param identificationHints
         *        a consumer that will call methods on {@link IdentificationHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identificationHints(IdentificationHints)
         */
        default Builder identificationHints(Consumer<IdentificationHints.Builder> identificationHints) {
            return identificationHints(IdentificationHints.builder().applyMutation(identificationHints).build());
        }

        /**
         * <p>
         * The date and time the Recovery Instance properties were last updated on.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time the Recovery Instance properties were last updated on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(String lastUpdatedDateTime);

        /**
         * <p>
         * An array of network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        An array of network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces);

        /**
         * <p>
         * An array of network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        An array of network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(NetworkInterface... networkInterfaces);

        /**
         * <p>
         * An array of network interfaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.NetworkInterface.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.drs.model.NetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.NetworkInterface.Builder#build()} is called immediately and
         * its result is passed to {@link #networkInterfaces(List<NetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<NetworkInterface>)
         */
        Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces);

        /**
         * <p>
         * Operating system.
         * </p>
         * 
         * @param os
         *        Operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(OS os);

        /**
         * <p>
         * Operating system.
         * </p>
         * This is a convenience method that creates an instance of the {@link OS.Builder} avoiding the need to create
         * one manually via {@link OS#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OS.Builder#build()} is called immediately and its result is
         * passed to {@link #os(OS)}.
         * 
         * @param os
         *        a consumer that will call methods on {@link OS.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #os(OS)
         */
        default Builder os(Consumer<OS.Builder> os) {
            return os(OS.builder().applyMutation(os).build());
        }

        /**
         * <p>
         * The amount of RAM in bytes.
         * </p>
         * 
         * @param ramBytes
         *        The amount of RAM in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramBytes(Long ramBytes);
    }

    static final class BuilderImpl implements Builder {
        private List<CPU> cpus = DefaultSdkAutoConstructList.getInstance();

        private List<RecoveryInstanceDisk> disks = DefaultSdkAutoConstructList.getInstance();

        private IdentificationHints identificationHints;

        private String lastUpdatedDateTime;

        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private OS os;

        private Long ramBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceProperties model) {
            cpus(model.cpus);
            disks(model.disks);
            identificationHints(model.identificationHints);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            networkInterfaces(model.networkInterfaces);
            os(model.os);
            ramBytes(model.ramBytes);
        }

        public final List<CPU.Builder> getCpus() {
            List<CPU.Builder> result = CpusCopier.copyToBuilder(this.cpus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCpus(Collection<CPU.BuilderImpl> cpus) {
            this.cpus = CpusCopier.copyFromBuilder(cpus);
        }

        @Override
        public final Builder cpus(Collection<CPU> cpus) {
            this.cpus = CpusCopier.copy(cpus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpus(CPU... cpus) {
            cpus(Arrays.asList(cpus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpus(Consumer<CPU.Builder>... cpus) {
            cpus(Stream.of(cpus).map(c -> CPU.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecoveryInstanceDisk.Builder> getDisks() {
            List<RecoveryInstanceDisk.Builder> result = RecoveryInstanceDisksCopier.copyToBuilder(this.disks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisks(Collection<RecoveryInstanceDisk.BuilderImpl> disks) {
            this.disks = RecoveryInstanceDisksCopier.copyFromBuilder(disks);
        }

        @Override
        public final Builder disks(Collection<RecoveryInstanceDisk> disks) {
            this.disks = RecoveryInstanceDisksCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(RecoveryInstanceDisk... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<RecoveryInstanceDisk.Builder>... disks) {
            disks(Stream.of(disks).map(c -> RecoveryInstanceDisk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IdentificationHints.Builder getIdentificationHints() {
            return identificationHints != null ? identificationHints.toBuilder() : null;
        }

        public final void setIdentificationHints(IdentificationHints.BuilderImpl identificationHints) {
            this.identificationHints = identificationHints != null ? identificationHints.build() : null;
        }

        @Override
        public final Builder identificationHints(IdentificationHints identificationHints) {
            this.identificationHints = identificationHints;
            return this;
        }

        public final String getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(String lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(String lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces).map(c -> NetworkInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OS.Builder getOs() {
            return os != null ? os.toBuilder() : null;
        }

        public final void setOs(OS.BuilderImpl os) {
            this.os = os != null ? os.build() : null;
        }

        @Override
        public final Builder os(OS os) {
            this.os = os;
            return this;
        }

        public final Long getRamBytes() {
            return ramBytes;
        }

        public final void setRamBytes(Long ramBytes) {
            this.ramBytes = ramBytes;
        }

        @Override
        public final Builder ramBytes(Long ramBytes) {
            this.ramBytes = ramBytes;
            return this;
        }

        @Override
        public RecoveryInstanceProperties build() {
            return new RecoveryInstanceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
