/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of Source Network related to a job event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceNetworkData implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceNetworkData.Builder, SourceNetworkData> {
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceNetworkID").getter(getter(SourceNetworkData::sourceNetworkID))
            .setter(setter(Builder::sourceNetworkID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()).build();

    private static final SdkField<String> SOURCE_VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVpc").getter(getter(SourceNetworkData::sourceVpc)).setter(setter(Builder::sourceVpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVpc").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackName").getter(getter(SourceNetworkData::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()).build();

    private static final SdkField<String> TARGET_VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetVpc").getter(getter(SourceNetworkData::targetVpc)).setter(setter(Builder::targetVpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_ID_FIELD,
            SOURCE_VPC_FIELD, STACK_NAME_FIELD, TARGET_VPC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceNetworkID;

    private final String sourceVpc;

    private final String stackName;

    private final String targetVpc;

    private SourceNetworkData(BuilderImpl builder) {
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceVpc = builder.sourceVpc;
        this.stackName = builder.stackName;
        this.targetVpc = builder.targetVpc;
    }

    /**
     * <p>
     * Source Network ID.
     * </p>
     * 
     * @return Source Network ID.
     */
    public final String sourceNetworkID() {
        return sourceNetworkID;
    }

    /**
     * <p>
     * VPC ID protected by the Source Network.
     * </p>
     * 
     * @return VPC ID protected by the Source Network.
     */
    public final String sourceVpc() {
        return sourceVpc;
    }

    /**
     * <p>
     * CloudFormation stack name that was deployed for recovering the Source Network.
     * </p>
     * 
     * @return CloudFormation stack name that was deployed for recovering the Source Network.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * ID of the recovered VPC following Source Network recovery.
     * </p>
     * 
     * @return ID of the recovered VPC following Source Network recovery.
     */
    public final String targetVpc() {
        return targetVpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(targetVpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceNetworkData)) {
            return false;
        }
        SourceNetworkData other = (SourceNetworkData) obj;
        return Objects.equals(sourceNetworkID(), other.sourceNetworkID()) && Objects.equals(sourceVpc(), other.sourceVpc())
                && Objects.equals(stackName(), other.stackName()) && Objects.equals(targetVpc(), other.targetVpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceNetworkData").add("SourceNetworkID", sourceNetworkID()).add("SourceVpc", sourceVpc())
                .add("StackName", stackName()).add("TargetVpc", targetVpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceNetworkID":
            return Optional.ofNullable(clazz.cast(sourceNetworkID()));
        case "sourceVpc":
            return Optional.ofNullable(clazz.cast(sourceVpc()));
        case "stackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "targetVpc":
            return Optional.ofNullable(clazz.cast(targetVpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceNetworkID", SOURCE_NETWORK_ID_FIELD);
        map.put("sourceVpc", SOURCE_VPC_FIELD);
        map.put("stackName", STACK_NAME_FIELD);
        map.put("targetVpc", TARGET_VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceNetworkData, T> g) {
        return obj -> g.apply((SourceNetworkData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceNetworkData> {
        /**
         * <p>
         * Source Network ID.
         * </p>
         * 
         * @param sourceNetworkID
         *        Source Network ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkID(String sourceNetworkID);

        /**
         * <p>
         * VPC ID protected by the Source Network.
         * </p>
         * 
         * @param sourceVpc
         *        VPC ID protected by the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVpc(String sourceVpc);

        /**
         * <p>
         * CloudFormation stack name that was deployed for recovering the Source Network.
         * </p>
         * 
         * @param stackName
         *        CloudFormation stack name that was deployed for recovering the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * ID of the recovered VPC following Source Network recovery.
         * </p>
         * 
         * @param targetVpc
         *        ID of the recovered VPC following Source Network recovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVpc(String targetVpc);
    }

    static final class BuilderImpl implements Builder {
        private String sourceNetworkID;

        private String sourceVpc;

        private String stackName;

        private String targetVpc;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceNetworkData model) {
            sourceNetworkID(model.sourceNetworkID);
            sourceVpc(model.sourceVpc);
            stackName(model.stackName);
            targetVpc(model.targetVpc);
        }

        public final String getSourceNetworkID() {
            return sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final String getSourceVpc() {
            return sourceVpc;
        }

        public final void setSourceVpc(String sourceVpc) {
            this.sourceVpc = sourceVpc;
        }

        @Override
        public final Builder sourceVpc(String sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getTargetVpc() {
            return targetVpc;
        }

        public final void setTargetVpc(String targetVpc) {
            this.targetVpc = targetVpc;
        }

        @Override
        public final Builder targetVpc(String targetVpc) {
            this.targetVpc = targetVpc;
            return this;
        }

        @Override
        public SourceNetworkData build() {
            return new SourceNetworkData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
