/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Staging information related to source server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StagingArea implements SdkPojo, Serializable, ToCopyableBuilder<StagingArea.Builder, StagingArea> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(StagingArea::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> STAGING_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingAccountID").getter(getter(StagingArea::stagingAccountID))
            .setter(setter(Builder::stagingAccountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAccountID").build()).build();

    private static final SdkField<String> STAGING_SOURCE_SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingSourceServerArn").getter(getter(StagingArea::stagingSourceServerArn))
            .setter(setter(Builder::stagingSourceServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingSourceServerArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StagingArea::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            STAGING_ACCOUNT_ID_FIELD, STAGING_SOURCE_SERVER_ARN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String stagingAccountID;

    private final String stagingSourceServerArn;

    private final String status;

    private StagingArea(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.stagingAccountID = builder.stagingAccountID;
        this.stagingSourceServerArn = builder.stagingSourceServerArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * Shows an error message that occurred when DRS tried to access the staging source server. In this case
     * StagingArea$status will have value EXTENSION_ERROR
     * </p>
     * 
     * @return Shows an error message that occurred when DRS tried to access the staging source server. In this case
     *         StagingArea$status will have value EXTENSION_ERROR
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Account ID of the account to which source server belongs. If this source server is extended - shows Account ID of
     * staging source server.
     * </p>
     * 
     * @return Account ID of the account to which source server belongs. If this source server is extended - shows
     *         Account ID of staging source server.
     */
    public final String stagingAccountID() {
        return stagingAccountID;
    }

    /**
     * <p>
     * Arn of the staging source server if this source server is extended
     * </p>
     * 
     * @return Arn of the staging source server if this source server is extended
     */
    public final String stagingSourceServerArn() {
        return stagingSourceServerArn;
    }

    /**
     * <p>
     * Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
     * replicating in the current account. (b) EXTENDED - Source server is extended from a staging source server. In
     * this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in the staging
     * account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In this case,
     * errorMessage field will contain an error message that explains what happened.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExtensionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
     *         replicating in the current account. (b) EXTENDED - Source server is extended from a staging source
     *         server. In this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in
     *         the staging account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In
     *         this case, errorMessage field will contain an error message that explains what happened.
     * @see ExtensionStatus
     */
    public final ExtensionStatus status() {
        return ExtensionStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
     * replicating in the current account. (b) EXTENDED - Source server is extended from a staging source server. In
     * this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in the staging
     * account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In this case,
     * errorMessage field will contain an error message that explains what happened.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExtensionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
     *         replicating in the current account. (b) EXTENDED - Source server is extended from a staging source
     *         server. In this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in
     *         the staging account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In
     *         this case, errorMessage field will contain an error message that explains what happened.
     * @see ExtensionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stagingAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(stagingSourceServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StagingArea)) {
            return false;
        }
        StagingArea other = (StagingArea) obj;
        return Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(stagingAccountID(), other.stagingAccountID())
                && Objects.equals(stagingSourceServerArn(), other.stagingSourceServerArn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StagingArea").add("ErrorMessage", errorMessage()).add("StagingAccountID", stagingAccountID())
                .add("StagingSourceServerArn", stagingSourceServerArn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "stagingAccountID":
            return Optional.ofNullable(clazz.cast(stagingAccountID()));
        case "stagingSourceServerArn":
            return Optional.ofNullable(clazz.cast(stagingSourceServerArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("stagingAccountID", STAGING_ACCOUNT_ID_FIELD);
        map.put("stagingSourceServerArn", STAGING_SOURCE_SERVER_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StagingArea, T> g) {
        return obj -> g.apply((StagingArea) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StagingArea> {
        /**
         * <p>
         * Shows an error message that occurred when DRS tried to access the staging source server. In this case
         * StagingArea$status will have value EXTENSION_ERROR
         * </p>
         * 
         * @param errorMessage
         *        Shows an error message that occurred when DRS tried to access the staging source server. In this case
         *        StagingArea$status will have value EXTENSION_ERROR
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Account ID of the account to which source server belongs. If this source server is extended - shows Account
         * ID of staging source server.
         * </p>
         * 
         * @param stagingAccountID
         *        Account ID of the account to which source server belongs. If this source server is extended - shows
         *        Account ID of staging source server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAccountID(String stagingAccountID);

        /**
         * <p>
         * Arn of the staging source server if this source server is extended
         * </p>
         * 
         * @param stagingSourceServerArn
         *        Arn of the staging source server if this source server is extended
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingSourceServerArn(String stagingSourceServerArn);

        /**
         * <p>
         * Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
         * replicating in the current account. (b) EXTENDED - Source server is extended from a staging source server. In
         * this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in the staging
         * account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In this case,
         * errorMessage field will contain an error message that explains what happened.
         * </p>
         * 
         * @param status
         *        Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
         *        replicating in the current account. (b) EXTENDED - Source server is extended from a staging source
         *        server. In this case, the value of stagingSourceServerArn is pointing to the Arn of the source server
         *        in the staging account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source
         *        server. In this case, errorMessage field will contain an error message that explains what happened.
         * @see ExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtensionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
         * replicating in the current account. (b) EXTENDED - Source server is extended from a staging source server. In
         * this case, the value of stagingSourceServerArn is pointing to the Arn of the source server in the staging
         * account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source server. In this case,
         * errorMessage field will contain an error message that explains what happened.
         * </p>
         * 
         * @param status
         *        Status of Source server extension. Possible values: (a) NOT_EXTENDED - This is a source server that is
         *        replicating in the current account. (b) EXTENDED - Source server is extended from a staging source
         *        server. In this case, the value of stagingSourceServerArn is pointing to the Arn of the source server
         *        in the staging account. (c) EXTENSION_ERROR - Some issue occurred when accessing staging source
         *        server. In this case, errorMessage field will contain an error message that explains what happened.
         * @see ExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtensionStatus
         */
        Builder status(ExtensionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String stagingAccountID;

        private String stagingSourceServerArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StagingArea model) {
            errorMessage(model.errorMessage);
            stagingAccountID(model.stagingAccountID);
            stagingSourceServerArn(model.stagingSourceServerArn);
            status(model.status);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStagingAccountID() {
            return stagingAccountID;
        }

        public final void setStagingAccountID(String stagingAccountID) {
            this.stagingAccountID = stagingAccountID;
        }

        @Override
        public final Builder stagingAccountID(String stagingAccountID) {
            this.stagingAccountID = stagingAccountID;
            return this;
        }

        public final String getStagingSourceServerArn() {
            return stagingSourceServerArn;
        }

        public final void setStagingSourceServerArn(String stagingSourceServerArn) {
            this.stagingSourceServerArn = stagingSourceServerArn;
        }

        @Override
        public final Builder stagingSourceServerArn(String stagingSourceServerArn) {
            this.stagingSourceServerArn = stagingSourceServerArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExtensionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StagingArea build() {
            return new StagingArea(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
