/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRecoveryRequest extends DrsRequest implements
        ToCopyableBuilder<StartRecoveryRequest.Builder, StartRecoveryRequest> {
    private static final SdkField<Boolean> IS_DRILL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDrill").getter(getter(StartRecoveryRequest::isDrill)).setter(setter(Builder::isDrill))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDrill").build()).build();

    private static final SdkField<List<StartRecoveryRequestSourceServer>> SOURCE_SERVERS_FIELD = SdkField
            .<List<StartRecoveryRequestSourceServer>> builder(MarshallingType.LIST)
            .memberName("sourceServers")
            .getter(getter(StartRecoveryRequest::sourceServers))
            .setter(setter(Builder::sourceServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StartRecoveryRequestSourceServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(StartRecoveryRequestSourceServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartRecoveryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DRILL_FIELD,
            SOURCE_SERVERS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean isDrill;

    private final List<StartRecoveryRequestSourceServer> sourceServers;

    private final Map<String, String> tags;

    private StartRecoveryRequest(BuilderImpl builder) {
        super(builder);
        this.isDrill = builder.isDrill;
        this.sourceServers = builder.sourceServers;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Whether this Source Server Recovery operation is a drill or not.
     * </p>
     * 
     * @return Whether this Source Server Recovery operation is a drill or not.
     */
    public final Boolean isDrill() {
        return isDrill;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceServers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceServers() {
        return sourceServers != null && !(sourceServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Source Servers that we want to start a Recovery Job for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceServers} method.
     * </p>
     * 
     * @return The Source Servers that we want to start a Recovery Job for.
     */
    public final List<StartRecoveryRequestSourceServer> sourceServers() {
        return sourceServers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be associated with the Recovery Job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be associated with the Recovery Job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(isDrill());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServers() ? sourceServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecoveryRequest)) {
            return false;
        }
        StartRecoveryRequest other = (StartRecoveryRequest) obj;
        return Objects.equals(isDrill(), other.isDrill()) && hasSourceServers() == other.hasSourceServers()
                && Objects.equals(sourceServers(), other.sourceServers()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRecoveryRequest").add("IsDrill", isDrill())
                .add("SourceServers", hasSourceServers() ? sourceServers() : null)
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isDrill":
            return Optional.ofNullable(clazz.cast(isDrill()));
        case "sourceServers":
            return Optional.ofNullable(clazz.cast(sourceServers()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isDrill", IS_DRILL_FIELD);
        map.put("sourceServers", SOURCE_SERVERS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRecoveryRequest, T> g) {
        return obj -> g.apply((StartRecoveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRecoveryRequest> {
        /**
         * <p>
         * Whether this Source Server Recovery operation is a drill or not.
         * </p>
         * 
         * @param isDrill
         *        Whether this Source Server Recovery operation is a drill or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDrill(Boolean isDrill);

        /**
         * <p>
         * The Source Servers that we want to start a Recovery Job for.
         * </p>
         * 
         * @param sourceServers
         *        The Source Servers that we want to start a Recovery Job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServers(Collection<StartRecoveryRequestSourceServer> sourceServers);

        /**
         * <p>
         * The Source Servers that we want to start a Recovery Job for.
         * </p>
         * 
         * @param sourceServers
         *        The Source Servers that we want to start a Recovery Job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServers(StartRecoveryRequestSourceServer... sourceServers);

        /**
         * <p>
         * The Source Servers that we want to start a Recovery Job for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServer.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServer.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceServers(List<StartRecoveryRequestSourceServer>)}.
         * 
         * @param sourceServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceServers(java.util.Collection<StartRecoveryRequestSourceServer>)
         */
        Builder sourceServers(Consumer<StartRecoveryRequestSourceServer.Builder>... sourceServers);

        /**
         * <p>
         * The tags to be associated with the Recovery Job.
         * </p>
         * 
         * @param tags
         *        The tags to be associated with the Recovery Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private Boolean isDrill;

        private List<StartRecoveryRequestSourceServer> sourceServers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecoveryRequest model) {
            super(model);
            isDrill(model.isDrill);
            sourceServers(model.sourceServers);
            tags(model.tags);
        }

        public final Boolean getIsDrill() {
            return isDrill;
        }

        public final void setIsDrill(Boolean isDrill) {
            this.isDrill = isDrill;
        }

        @Override
        public final Builder isDrill(Boolean isDrill) {
            this.isDrill = isDrill;
            return this;
        }

        public final List<StartRecoveryRequestSourceServer.Builder> getSourceServers() {
            List<StartRecoveryRequestSourceServer.Builder> result = StartRecoveryRequestSourceServersCopier
                    .copyToBuilder(this.sourceServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceServers(Collection<StartRecoveryRequestSourceServer.BuilderImpl> sourceServers) {
            this.sourceServers = StartRecoveryRequestSourceServersCopier.copyFromBuilder(sourceServers);
        }

        @Override
        public final Builder sourceServers(Collection<StartRecoveryRequestSourceServer> sourceServers) {
            this.sourceServers = StartRecoveryRequestSourceServersCopier.copy(sourceServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServers(StartRecoveryRequestSourceServer... sourceServers) {
            sourceServers(Arrays.asList(sourceServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServers(Consumer<StartRecoveryRequestSourceServer.Builder>... sourceServers) {
            sourceServers(Stream.of(sourceServers).map(c -> StartRecoveryRequestSourceServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRecoveryRequest build() {
            return new StartRecoveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
