/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopReplicationResponse extends DrsResponse implements
        ToCopyableBuilder<StopReplicationResponse.Builder, StopReplicationResponse> {
    private static final SdkField<SourceServer> SOURCE_SERVER_FIELD = SdkField.<SourceServer> builder(MarshallingType.SDK_POJO)
            .memberName("sourceServer").getter(getter(StopReplicationResponse::sourceServer))
            .setter(setter(Builder::sourceServer)).constructor(SourceServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SourceServer sourceServer;

    private StopReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceServer = builder.sourceServer;
    }

    /**
     * <p>
     * The Source Server that this action was targeted on.
     * </p>
     * 
     * @return The Source Server that this action was targeted on.
     */
    public final SourceServer sourceServer() {
        return sourceServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopReplicationResponse)) {
            return false;
        }
        StopReplicationResponse other = (StopReplicationResponse) obj;
        return Objects.equals(sourceServer(), other.sourceServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopReplicationResponse").add("SourceServer", sourceServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceServer":
            return Optional.ofNullable(clazz.cast(sourceServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceServer", SOURCE_SERVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopReplicationResponse, T> g) {
        return obj -> g.apply((StopReplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopReplicationResponse> {
        /**
         * <p>
         * The Source Server that this action was targeted on.
         * </p>
         * 
         * @param sourceServer
         *        The Source Server that this action was targeted on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServer(SourceServer sourceServer);

        /**
         * <p>
         * The Source Server that this action was targeted on.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceServer.Builder} avoiding the need
         * to create one manually via {@link SourceServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceServer.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceServer(SourceServer)}.
         * 
         * @param sourceServer
         *        a consumer that will call methods on {@link SourceServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceServer(SourceServer)
         */
        default Builder sourceServer(Consumer<SourceServer.Builder> sourceServer) {
            return sourceServer(SourceServer.builder().applyMutation(sourceServer).build());
        }
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private SourceServer sourceServer;

        private BuilderImpl() {
        }

        private BuilderImpl(StopReplicationResponse model) {
            super(model);
            sourceServer(model.sourceServer);
        }

        public final SourceServer.Builder getSourceServer() {
            return sourceServer != null ? sourceServer.toBuilder() : null;
        }

        public final void setSourceServer(SourceServer.BuilderImpl sourceServer) {
            this.sourceServer = sourceServer != null ? sourceServer.build() : null;
        }

        @Override
        public final Builder sourceServer(SourceServer sourceServer) {
            this.sourceServer = sourceServer;
            return this;
        }

        @Override
        public StopReplicationResponse build() {
            return new StopReplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
