/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopSourceNetworkReplicationResponse extends DrsResponse implements
        ToCopyableBuilder<StopSourceNetworkReplicationResponse.Builder, StopSourceNetworkReplicationResponse> {
    private static final SdkField<SourceNetwork> SOURCE_NETWORK_FIELD = SdkField
            .<SourceNetwork> builder(MarshallingType.SDK_POJO).memberName("sourceNetwork")
            .getter(getter(StopSourceNetworkReplicationResponse::sourceNetwork)).setter(setter(Builder::sourceNetwork))
            .constructor(SourceNetwork::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetwork").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SourceNetwork sourceNetwork;

    private StopSourceNetworkReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceNetwork = builder.sourceNetwork;
    }

    /**
     * <p>
     * Source Network which was requested to stop replication.
     * </p>
     * 
     * @return Source Network which was requested to stop replication.
     */
    public final SourceNetwork sourceNetwork() {
        return sourceNetwork;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetwork());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopSourceNetworkReplicationResponse)) {
            return false;
        }
        StopSourceNetworkReplicationResponse other = (StopSourceNetworkReplicationResponse) obj;
        return Objects.equals(sourceNetwork(), other.sourceNetwork());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopSourceNetworkReplicationResponse").add("SourceNetwork", sourceNetwork()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceNetwork":
            return Optional.ofNullable(clazz.cast(sourceNetwork()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceNetwork", SOURCE_NETWORK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopSourceNetworkReplicationResponse, T> g) {
        return obj -> g.apply((StopSourceNetworkReplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopSourceNetworkReplicationResponse> {
        /**
         * <p>
         * Source Network which was requested to stop replication.
         * </p>
         * 
         * @param sourceNetwork
         *        Source Network which was requested to stop replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetwork(SourceNetwork sourceNetwork);

        /**
         * <p>
         * Source Network which was requested to stop replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceNetwork.Builder} avoiding the need
         * to create one manually via {@link SourceNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceNetwork.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceNetwork(SourceNetwork)}.
         * 
         * @param sourceNetwork
         *        a consumer that will call methods on {@link SourceNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceNetwork(SourceNetwork)
         */
        default Builder sourceNetwork(Consumer<SourceNetwork.Builder> sourceNetwork) {
            return sourceNetwork(SourceNetwork.builder().applyMutation(sourceNetwork).build());
        }
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private SourceNetwork sourceNetwork;

        private BuilderImpl() {
        }

        private BuilderImpl(StopSourceNetworkReplicationResponse model) {
            super(model);
            sourceNetwork(model.sourceNetwork);
        }

        public final SourceNetwork.Builder getSourceNetwork() {
            return sourceNetwork != null ? sourceNetwork.toBuilder() : null;
        }

        public final void setSourceNetwork(SourceNetwork.BuilderImpl sourceNetwork) {
            this.sourceNetwork = sourceNetwork != null ? sourceNetwork.build() : null;
        }

        @Override
        public final Builder sourceNetwork(SourceNetwork sourceNetwork) {
            this.sourceNetwork = sourceNetwork;
            return this;
        }

        @Override
        public StopSourceNetworkReplicationResponse build() {
            return new StopSourceNetworkReplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
