/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.dsql.DsqlClient;
import software.amazon.awssdk.services.dsql.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.dsql.model.DsqlRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.waiters.DsqlWaiter;
import software.amazon.awssdk.services.dsql.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultDsqlWaiter
implements DsqlWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final DsqlClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetClusterResponse> clusterActiveWaiter;
    private final Waiter<GetClusterResponse> clusterNotExistsWaiter;

    private DefaultDsqlWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DsqlClient)DsqlClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetClusterResponse.class).acceptors(DefaultDsqlWaiter.clusterActiveWaiterAcceptors())).overrideConfiguration(DefaultDsqlWaiter.clusterActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetClusterResponse.class).acceptors(DefaultDsqlWaiter.clusterNotExistsWaiterAcceptors())).overrideConfiguration(DefaultDsqlWaiter.clusterNotExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetClusterResponse> waitUntilClusterActive(GetClusterRequest getClusterRequest) {
        return this.clusterActiveWaiter.run(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)));
    }

    @Override
    public WaiterResponse<GetClusterResponse> waitUntilClusterActive(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterActiveWaiter.run(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)), DefaultDsqlWaiter.clusterActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetClusterResponse> waitUntilClusterNotExists(GetClusterRequest getClusterRequest) {
        return this.clusterNotExistsWaiter.run(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)));
    }

    @Override
    public WaiterResponse<GetClusterResponse> waitUntilClusterNotExists(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterNotExistsWaiter.run(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)), DefaultDsqlWaiter.clusterNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetClusterResponse>> clusterActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetClusterResponse>> result = new ArrayList<WaiterAcceptor<? super GetClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetClusterResponse>> clusterNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetClusterResponse>> result = new ArrayList<WaiterAcceptor<? super GetClusterResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDsqlWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DsqlWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DsqlRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DsqlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DsqlWaiter.Builder {
        private DsqlClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public DsqlWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DsqlWaiter.Builder client(DsqlClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DsqlWaiter build() {
            return new DefaultDsqlWaiter(this);
        }
    }
}

