/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTable;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGlobalTablesResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListGlobalTablesResponse> {
    private static final SdkField<List<GlobalTable>> GLOBAL_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalTables").getter(ListGlobalTablesResponse.getter(ListGlobalTablesResponse::globalTables)).setter(ListGlobalTablesResponse.setter(Builder::globalTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_EVALUATED_GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedGlobalTableName").getter(ListGlobalTablesResponse.getter(ListGlobalTablesResponse::lastEvaluatedGlobalTableName)).setter(ListGlobalTablesResponse.setter(Builder::lastEvaluatedGlobalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedGlobalTableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLES_FIELD, LAST_EVALUATED_GLOBAL_TABLE_NAME_FIELD));
    private final List<GlobalTable> globalTables;
    private final String lastEvaluatedGlobalTableName;

    private ListGlobalTablesResponse(BuilderImpl builder) {
        super(builder);
        this.globalTables = builder.globalTables;
        this.lastEvaluatedGlobalTableName = builder.lastEvaluatedGlobalTableName;
    }

    public final boolean hasGlobalTables() {
        return this.globalTables != null && !(this.globalTables instanceof SdkAutoConstructList);
    }

    public final List<GlobalTable> globalTables() {
        return this.globalTables;
    }

    public final String lastEvaluatedGlobalTableName() {
        return this.lastEvaluatedGlobalTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalTables() ? this.globalTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedGlobalTableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesResponse)) {
            return false;
        }
        ListGlobalTablesResponse other = (ListGlobalTablesResponse)((Object)obj);
        return this.hasGlobalTables() == other.hasGlobalTables() && Objects.equals(this.globalTables(), other.globalTables()) && Objects.equals(this.lastEvaluatedGlobalTableName(), other.lastEvaluatedGlobalTableName());
    }

    public final String toString() {
        return ToString.builder((String)"ListGlobalTablesResponse").add("GlobalTables", this.hasGlobalTables() ? this.globalTables() : null).add("LastEvaluatedGlobalTableName", (Object)this.lastEvaluatedGlobalTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTables": {
                return Optional.ofNullable(clazz.cast(this.globalTables()));
            }
            case "LastEvaluatedGlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedGlobalTableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGlobalTablesResponse, T> g) {
        return obj -> g.apply((ListGlobalTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<GlobalTable> globalTables = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedGlobalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesResponse model) {
            super(model);
            this.globalTables(model.globalTables);
            this.lastEvaluatedGlobalTableName(model.lastEvaluatedGlobalTableName);
        }

        public final List<GlobalTable.Builder> getGlobalTables() {
            List<GlobalTable.Builder> result = GlobalTableListCopier.copyToBuilder(this.globalTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder globalTables(Collection<GlobalTable> globalTables) {
            this.globalTables = GlobalTableListCopier.copy(globalTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(GlobalTable ... globalTables) {
            this.globalTables(Arrays.asList(globalTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(Consumer<GlobalTable.Builder> ... globalTables) {
            this.globalTables(Stream.of(globalTables).map(c -> (GlobalTable)((GlobalTable.Builder)GlobalTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTables(Collection<GlobalTable.BuilderImpl> globalTables) {
            this.globalTables = GlobalTableListCopier.copyFromBuilder(globalTables);
        }

        public final String getLastEvaluatedGlobalTableName() {
            return this.lastEvaluatedGlobalTableName;
        }

        @Override
        public final Builder lastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
            return this;
        }

        public final void setLastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
        }

        @Override
        public ListGlobalTablesResponse build() {
            return new ListGlobalTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGlobalTablesResponse> {
        public Builder globalTables(Collection<GlobalTable> var1);

        public Builder globalTables(GlobalTable ... var1);

        public Builder globalTables(Consumer<GlobalTable.Builder> ... var1);

        public Builder lastEvaluatedGlobalTableName(String var1);
    }
}

