/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.PartiQLBatchResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, BatchExecuteStatementResponse> {
    private static final SdkField<List<BatchStatementResponse>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Responses").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::responses)).setter(BatchExecuteStatementResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchStatementResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedCapacity").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::consumedCapacity)).setter(BatchExecuteStatementResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD, CONSUMED_CAPACITY_FIELD));
    private final List<BatchStatementResponse> responses;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public final List<BatchStatementResponse> responses() {
        return this.responses;
    }

    public final boolean hasConsumedCapacity() {
        return this.consumedCapacity != null && !(this.consumedCapacity instanceof SdkAutoConstructList);
    }

    public final List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedCapacity() ? this.consumedCapacity() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementResponse)) {
            return false;
        }
        BatchExecuteStatementResponse other = (BatchExecuteStatementResponse)((Object)obj);
        return this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses()) && this.hasConsumedCapacity() == other.hasConsumedCapacity() && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementResponse").add("Responses", this.hasResponses() ? this.responses() : null).add("ConsumedCapacity", this.hasConsumedCapacity() ? this.consumedCapacity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementResponse, T> g) {
        return obj -> g.apply((BatchExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<BatchStatementResponse> responses = DefaultSdkAutoConstructList.getInstance();
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementResponse model) {
            super(model);
            this.responses(model.responses);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final List<BatchStatementResponse.Builder> getResponses() {
            List<BatchStatementResponse.Builder> result = PartiQLBatchResponseCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<BatchStatementResponse.BuilderImpl> responses) {
            this.responses = PartiQLBatchResponseCopier.copyFromBuilder(responses);
        }

        @Override
        @Transient
        public final Builder responses(Collection<BatchStatementResponse> responses) {
            this.responses = PartiQLBatchResponseCopier.copy(responses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responses(BatchStatementResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responses(Consumer<BatchStatementResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (BatchStatementResponse)((BatchStatementResponse.Builder)BatchStatementResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ConsumedCapacity.Builder> getConsumedCapacity() {
            List<ConsumedCapacity.Builder> result = ConsumedCapacityMultipleCopier.copyToBuilder(this.consumedCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        @Transient
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchExecuteStatementResponse build() {
            return new BatchExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementResponse> {
        public Builder responses(Collection<BatchStatementResponse> var1);

        public Builder responses(BatchStatementResponse ... var1);

        public Builder responses(Consumer<BatchStatementResponse.Builder> ... var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);
    }
}

