/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamRequest
extends DynamoDbStreamsRequest
implements ToCopyableBuilder<Builder, DescribeStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(DescribeStreamRequest.getter(DescribeStreamRequest::streamArn)).setter(DescribeStreamRequest.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeStreamRequest.getter(DescribeStreamRequest::limit)).setter(DescribeStreamRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartShardId").getter(DescribeStreamRequest.getter(DescribeStreamRequest::exclusiveStartShardId)).setter(DescribeStreamRequest.setter(Builder::exclusiveStartShardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, LIMIT_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StreamArn", STREAM_ARN_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("ExclusiveStartShardId", EXCLUSIVE_START_SHARD_ID_FIELD);
        }
    });
    private final String streamArn;
    private final Integer limit;
    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStreamRequest").add("StreamArn", (Object)this.streamArn()).add("Limit", (Object)this.limit()).add("ExclusiveStartShardId", (Object)this.exclusiveStartShardId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "ExclusiveStartShardId": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartShardId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamRequest, T> g) {
        return obj -> g.apply((DescribeStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbStreamsRequest.BuilderImpl
    implements Builder {
        private String streamArn;
        private Integer limit;
        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            super(model);
            this.streamArn(model.streamArn);
            this.limit(model.limit);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamRequest> {
        public Builder streamArn(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

