/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BinarySetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.ListAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.MapAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.NumberSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.StringSetAttributeValueCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S").getter(AttributeValue.getter(AttributeValue::s)).setter(AttributeValue.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<String> N_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("N").getter(AttributeValue.getter(AttributeValue::n)).setter(AttributeValue.setter(Builder::n)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()}).build();
    private static final SdkField<SdkBytes> B_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("B").getter(AttributeValue.getter(AttributeValue::b)).setter(AttributeValue.setter(Builder::b)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()}).build();
    private static final SdkField<List<String>> SS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SS").getter(AttributeValue.getter(AttributeValue::ss)).setter(AttributeValue.setter(Builder::ss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NS").getter(AttributeValue.getter(AttributeValue::ns)).setter(AttributeValue.setter(Builder::ns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SdkBytes>> BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BS").getter(AttributeValue.getter(AttributeValue::bs)).setter(AttributeValue.setter(Builder::bs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> M_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("M").getter(AttributeValue.getter(AttributeValue::m)).setter(AttributeValue.setter(Builder::m)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("M").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeValue>> L_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("L").getter(AttributeValue.getter(AttributeValue::l)).setter(AttributeValue.setter(Builder::l)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> BOOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BOOL").getter(AttributeValue.getter(AttributeValue::bool)).setter(AttributeValue.setter(Builder::bool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BOOL").build()}).build();
    private static final SdkField<Boolean> NUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NUL").getter(AttributeValue.getter(AttributeValue::nul)).setter(AttributeValue.setter(Builder::nul)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NULL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, B_FIELD, SS_FIELD, NS_FIELD, BS_FIELD, M_FIELD, L_FIELD, BOOL_FIELD, NUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s;
    private final String n;
    private final SdkBytes b;
    private final List<String> ss;
    private final List<String> ns;
    private final List<SdkBytes> bs;
    private final Map<String, AttributeValue> m;
    private final List<AttributeValue> l;
    private final Boolean bool;
    private final Boolean nul;
    private final Type type;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
        this.type = builder.type;
    }

    public final String s() {
        return this.s;
    }

    public final String n() {
        return this.n;
    }

    public final SdkBytes b() {
        return this.b;
    }

    public final boolean hasSs() {
        return this.ss != null && !(this.ss instanceof SdkAutoConstructList);
    }

    public final List<String> ss() {
        return this.ss;
    }

    public final boolean hasNs() {
        return this.ns != null && !(this.ns instanceof SdkAutoConstructList);
    }

    public final List<String> ns() {
        return this.ns;
    }

    public final boolean hasBs() {
        return this.bs != null && !(this.bs instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> bs() {
        return this.bs;
    }

    public final boolean hasM() {
        return this.m != null && !(this.m instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> m() {
        return this.m;
    }

    public final boolean hasL() {
        return this.l != null && !(this.l instanceof SdkAutoConstructList);
    }

    public final List<AttributeValue> l() {
        return this.l;
    }

    public final Boolean bool() {
        return this.bool;
    }

    public final Boolean nul() {
        return this.nul;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.b());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSs() ? this.ss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNs() ? this.ns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBs() ? this.bs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasM() ? this.m() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasL() ? this.l() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bool());
        hashCode = 31 * hashCode + Objects.hashCode(this.nul());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.b(), other.b()) && this.hasSs() == other.hasSs() && Objects.equals(this.ss(), other.ss()) && this.hasNs() == other.hasNs() && Objects.equals(this.ns(), other.ns()) && this.hasBs() == other.hasBs() && Objects.equals(this.bs(), other.bs()) && this.hasM() == other.hasM() && Objects.equals(this.m(), other.m()) && this.hasL() == other.hasL() && Objects.equals(this.l(), other.l()) && Objects.equals(this.bool(), other.bool()) && Objects.equals(this.nul(), other.nul());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValue").add("S", (Object)this.s()).add("N", (Object)this.n()).add("B", (Object)this.b()).add("SS", this.hasSs() ? this.ss() : null).add("NS", this.hasNs() ? this.ns() : null).add("BS", this.hasBs() ? this.bs() : null).add("M", this.hasM() ? this.m() : null).add("L", this.hasL() ? this.l() : null).add("BOOL", (Object)this.bool()).add("NUL", (Object)this.nul()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.ofNullable(clazz.cast(this.n()));
            }
            case "B": {
                return Optional.ofNullable(clazz.cast(this.b()));
            }
            case "SS": {
                return Optional.ofNullable(clazz.cast(this.ss()));
            }
            case "NS": {
                return Optional.ofNullable(clazz.cast(this.ns()));
            }
            case "BS": {
                return Optional.ofNullable(clazz.cast(this.bs()));
            }
            case "M": {
                return Optional.ofNullable(clazz.cast(this.m()));
            }
            case "L": {
                return Optional.ofNullable(clazz.cast(this.l()));
            }
            case "BOOL": {
                return Optional.ofNullable(clazz.cast(this.bool()));
            }
            case "NUL": {
                return Optional.ofNullable(clazz.cast(this.nul()));
            }
        }
        return Optional.empty();
    }

    public static AttributeValue fromS(String s) {
        return (AttributeValue)AttributeValue.builder().s(s).build();
    }

    public static AttributeValue fromN(String n) {
        return (AttributeValue)AttributeValue.builder().n(n).build();
    }

    public static AttributeValue fromB(SdkBytes b) {
        return (AttributeValue)AttributeValue.builder().b(b).build();
    }

    public static AttributeValue fromSs(List<String> ss) {
        return (AttributeValue)AttributeValue.builder().ss(ss).build();
    }

    public static AttributeValue fromNs(List<String> ns) {
        return (AttributeValue)AttributeValue.builder().ns(ns).build();
    }

    public static AttributeValue fromBs(List<SdkBytes> bs) {
        return (AttributeValue)AttributeValue.builder().bs(bs).build();
    }

    public static AttributeValue fromM(Map<String, AttributeValue> m) {
        return (AttributeValue)AttributeValue.builder().m(m).build();
    }

    public static AttributeValue fromL(List<AttributeValue> l) {
        return (AttributeValue)AttributeValue.builder().l(l).build();
    }

    public static AttributeValue fromBool(Boolean bool) {
        return (AttributeValue)AttributeValue.builder().bool(bool).build();
    }

    public static AttributeValue fromNul(Boolean nul) {
        return (AttributeValue)AttributeValue.builder().nul(nul).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S", S_FIELD);
        map.put("N", N_FIELD);
        map.put("B", B_FIELD);
        map.put("SS", SS_FIELD);
        map.put("NS", NS_FIELD);
        map.put("BS", BS_FIELD);
        map.put("M", M_FIELD);
        map.put("L", L_FIELD);
        map.put("BOOL", BOOL_FIELD);
        map.put("NULL", NUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S,
        N,
        B,
        SS,
        NS,
        BS,
        M,
        L,
        BOOL,
        NUL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private String n;
        private SdkBytes b;
        private List<String> ss = DefaultSdkAutoConstructList.getInstance();
        private List<String> ns = DefaultSdkAutoConstructList.getInstance();
        private List<SdkBytes> bs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AttributeValue> m = DefaultSdkAutoConstructMap.getInstance();
        private List<AttributeValue> l = DefaultSdkAutoConstructList.getInstance();
        private Boolean bool;
        private Boolean nul;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.b(model.b);
            this.ss(model.ss);
            this.ns(model.ns);
            this.bs(model.bs);
            this.m(model.m);
            this.l(model.l);
            this.bool(model.bool);
            this.nul(model.nul);
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            String oldValue = this.s;
            this.s = s;
            this.handleUnionValueChange(Type.S, oldValue, this.s);
        }

        @Override
        public final Builder s(String s) {
            String oldValue = this.s;
            this.s = s;
            this.handleUnionValueChange(Type.S, oldValue, this.s);
            return this;
        }

        public final String getN() {
            return this.n;
        }

        public final void setN(String n) {
            String oldValue = this.n;
            this.n = n;
            this.handleUnionValueChange(Type.N, oldValue, this.n);
        }

        @Override
        public final Builder n(String n) {
            String oldValue = this.n;
            this.n = n;
            this.handleUnionValueChange(Type.N, oldValue, this.n);
            return this;
        }

        public final ByteBuffer getB() {
            return this.b == null ? null : this.b.asByteBuffer();
        }

        public final void setB(ByteBuffer b) {
            this.b(b == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)b));
        }

        @Override
        public final Builder b(SdkBytes b) {
            SdkBytes oldValue = this.b;
            this.b = b;
            this.handleUnionValueChange(Type.B, oldValue, this.b);
            return this;
        }

        public final Collection<String> getSs() {
            if (this.ss instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ss;
        }

        public final void setSs(Collection<String> ss) {
            List<String> oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            this.handleUnionValueChange(Type.SS, oldValue, this.ss);
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            List<String> oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            this.handleUnionValueChange(Type.SS, oldValue, this.ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public final Collection<String> getNs() {
            if (this.ns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ns;
        }

        public final void setNs(Collection<String> ns) {
            List<String> oldValue = this.ns;
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            this.handleUnionValueChange(Type.NS, oldValue, this.ns);
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            List<String> oldValue = this.ns;
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            this.handleUnionValueChange(Type.NS, oldValue, this.ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String ... ns) {
            this.ns(Arrays.asList(ns));
            return this;
        }

        public final List<ByteBuffer> getBs() {
            if (this.bs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bs == null ? null : this.bs.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        public final void setBs(Collection<ByteBuffer> bs) {
            this.bs(bs == null ? null : (Collection)bs.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder bs(Collection<SdkBytes> bs) {
            List<SdkBytes> oldValue = this.bs;
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            this.handleUnionValueChange(Type.BS, oldValue, this.bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(SdkBytes ... bs) {
            this.bs(Arrays.asList(bs));
            return this;
        }

        public final Map<String, Builder> getM() {
            Map<String, Builder> result = MapAttributeValueCopier.copyToBuilder(this.m);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setM(Map<String, BuilderImpl> m) {
            Map<String, AttributeValue> oldValue = this.m;
            this.m = MapAttributeValueCopier.copyFromBuilder(m);
            this.handleUnionValueChange(Type.M, oldValue, this.m);
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            Map<String, AttributeValue> oldValue = this.m;
            this.m = MapAttributeValueCopier.copy(m);
            this.handleUnionValueChange(Type.M, oldValue, this.m);
            return this;
        }

        public final List<Builder> getL() {
            List<Builder> result = ListAttributeValueCopier.copyToBuilder(this.l);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setL(Collection<BuilderImpl> l) {
            List<AttributeValue> oldValue = this.l;
            this.l = ListAttributeValueCopier.copyFromBuilder(l);
            this.handleUnionValueChange(Type.L, oldValue, this.l);
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            List<AttributeValue> oldValue = this.l;
            this.l = ListAttributeValueCopier.copy(l);
            this.handleUnionValueChange(Type.L, oldValue, this.l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue ... l) {
            this.l(Arrays.asList(l));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(Consumer<Builder> ... l) {
            this.l(Stream.of(l).map(c -> (AttributeValue)((Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getBool() {
            return this.bool;
        }

        public final void setBool(Boolean bool) {
            Boolean oldValue = this.bool;
            this.bool = bool;
            this.handleUnionValueChange(Type.BOOL, oldValue, this.bool);
        }

        @Override
        public final Builder bool(Boolean bool) {
            Boolean oldValue = this.bool;
            this.bool = bool;
            this.handleUnionValueChange(Type.BOOL, oldValue, this.bool);
            return this;
        }

        public final Boolean getNul() {
            return this.nul;
        }

        public final void setNul(Boolean nul) {
            Boolean oldValue = this.nul;
            this.nul = nul;
            this.handleUnionValueChange(Type.NUL, oldValue, this.nul);
        }

        @Override
        public final Builder nul(Boolean nul) {
            Boolean oldValue = this.nul;
            this.nul = nul;
            this.handleUnionValueChange(Type.NUL, oldValue, this.nul);
            return this;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(String var1);

        public Builder b(SdkBytes var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);

        public Builder ns(Collection<String> var1);

        public Builder ns(String ... var1);

        public Builder bs(Collection<SdkBytes> var1);

        public Builder bs(SdkBytes ... var1);

        public Builder m(Map<String, AttributeValue> var1);

        public Builder l(Collection<AttributeValue> var1);

        public Builder l(AttributeValue ... var1);

        public Builder l(Consumer<Builder> ... var1);

        public Builder bool(Boolean var1);

        public Builder nul(Boolean var1);
    }
}

